/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator;

import io.confluent.connect.replicator.ReplicatorSourceConnectorConfig;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.config.ConfigDef;

public class ReplicatorSourceTaskConfig
extends ReplicatorSourceConnectorConfig {
    private static final String TASK_ID_CONFIG = "task.id";
    private static final String TASK_ID_DOC = "Task ID assigned by the connector (used for logging)";
    private static final String PARTITION_ASSIGNMENT_CONFIG = "partition.assignment";
    private static final String PARTITION_ASSIGNMENT_DOC = "";
    static final ConfigDef config = ReplicatorSourceTaskConfig.baseConfigDef().define("task.id", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Task ID assigned by the connector (used for logging)").define("partition.assignment", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "");

    public ReplicatorSourceTaskConfig(Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public String getTaskId() {
        return this.getString(TASK_ID_CONFIG);
    }

    public ConsumerPartitionAssignor.Assignment getPartitionAssignment() {
        return ReplicatorSourceTaskConfig.decodeAssignment(this.getString(PARTITION_ASSIGNMENT_CONFIG));
    }

    private static ConsumerPartitionAssignor.Assignment decodeAssignment(String encodedAssignment) {
        byte[] decodedAssignment = Base64.decodeBase64((String)encodedAssignment);
        return ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(decodedAssignment));
    }

    private static String encodeAssignment(ConsumerPartitionAssignor.Assignment assignment) {
        ByteBuffer byteBuffer = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)assignment);
        int length = byteBuffer.remaining();
        byte[] serializedAssignment = new byte[length];
        byteBuffer.get(serializedAssignment);
        return Base64.encodeBase64String((byte[])serializedAssignment);
    }

    public static Builder builder(ReplicatorSourceConnectorConfig config) {
        return new Builder(config.originalsStrings());
    }

    public static class Builder {
        private final Map<String, String> config;

        public Builder(Map<String, String> config) {
            this.config = new HashMap<String, String>(config);
        }

        public Builder setAssignment(ConsumerPartitionAssignor.Assignment assignment) {
            this.config.put(ReplicatorSourceTaskConfig.PARTITION_ASSIGNMENT_CONFIG, ReplicatorSourceTaskConfig.encodeAssignment(assignment));
            return this;
        }

        public Builder setTaskId(String taskId) {
            this.config.put(ReplicatorSourceTaskConfig.TASK_ID_CONFIG, taskId);
            return this;
        }

        public ReplicatorSourceTaskConfig build() {
            return new ReplicatorSourceTaskConfig(this.config);
        }
    }
}

