/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.annotation.processor;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.annotation.JobWorker;
import io.camunda.zeebe.spring.client.annotation.ZeebeWorker;
import io.camunda.zeebe.spring.client.annotation.customizer.ZeebeWorkerValueCustomizer;
import io.camunda.zeebe.spring.client.annotation.processor.AbstractZeebeAnnotationProcessor;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import io.camunda.zeebe.spring.client.bean.MethodInfo;
import io.camunda.zeebe.spring.client.jobhandling.JobWorkerManager;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ZeebeWorkerAnnotationProcessor
extends AbstractZeebeAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JobWorkerManager jobWorkerManager;
    private final List<ZeebeWorkerValue> zeebeWorkerValues = new ArrayList<ZeebeWorkerValue>();
    private final List<ZeebeWorkerValueCustomizer> zeebeWorkerValueCustomizers;
    private String defaultWorkerType;
    private String defaultWorkerName;

    public ZeebeWorkerAnnotationProcessor(JobWorkerManager jobWorkerFactory, List<ZeebeWorkerValueCustomizer> zeebeWorkerValueCustomizers, String defaultWorkerType, String defaultJobWorkerName) {
        this.jobWorkerManager = jobWorkerFactory;
        this.zeebeWorkerValueCustomizers = zeebeWorkerValueCustomizers;
        this.defaultWorkerType = defaultWorkerType;
        this.defaultWorkerName = defaultJobWorkerName;
    }

    @Override
    public boolean isApplicableFor(ClassInfo beanInfo) {
        return beanInfo.hasMethodAnnotation(JobWorker.class) || beanInfo.hasMethodAnnotation(ZeebeWorker.class);
    }

    @Override
    public void configureFor(ClassInfo beanInfo) {
        ArrayList newZeebeWorkerValues = new ArrayList();
        ReflectionUtils.doWithMethods(beanInfo.getTargetClass(), method -> this.readJobWorkerAnnotationForMethod(beanInfo.toMethodInfo(method)).ifPresent(newZeebeWorkerValues::add), (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        LOGGER.info("Configuring {} Zeebe worker(s) of bean '{}': {}", new Object[]{newZeebeWorkerValues.size(), beanInfo.getBeanName(), newZeebeWorkerValues});
        this.zeebeWorkerValues.addAll(newZeebeWorkerValues);
    }

    public Optional<ZeebeWorkerValue> readJobWorkerAnnotationForMethod(MethodInfo methodInfo) {
        Optional<JobWorker> methodAnnotation = methodInfo.getAnnotation(JobWorker.class);
        if (methodAnnotation.isPresent()) {
            JobWorker annotation = methodAnnotation.get();
            return Optional.of(new ZeebeWorkerValue().setMethodInfo(methodInfo).setType(annotation.type()).setTimeout(annotation.timeout()).setMaxJobsActive(annotation.maxJobsActive()).setPollInterval(annotation.pollInterval()).setAutoComplete(annotation.autoComplete()).setRequestTimeout(annotation.requestTimeout()).setEnabled(annotation.enabled()).initializeName(annotation.name(), methodInfo, this.defaultWorkerName).initializeFetchVariables(annotation.fetchAllVariables(), annotation.fetchVariables(), methodInfo).initializeJobType(annotation.type(), methodInfo, this.defaultWorkerType));
        }
        Optional<ZeebeWorker> legacyAnnotation = methodInfo.getAnnotation(ZeebeWorker.class);
        if (legacyAnnotation.isPresent()) {
            ZeebeWorker annotation = legacyAnnotation.get();
            return Optional.of(new ZeebeWorkerValue().setMethodInfo(methodInfo).setType(annotation.type()).setTimeout(annotation.timeout()).setMaxJobsActive(annotation.maxJobsActive()).setPollInterval(annotation.pollInterval()).setAutoComplete(annotation.autoComplete()).setRequestTimeout(annotation.requestTimeout()).setEnabled(annotation.enabled()).initializeName(annotation.name(), methodInfo, this.defaultWorkerName).initializeFetchVariables(annotation.forceFetchAllVariables(), annotation.fetchVariables(), methodInfo).initializeJobType(annotation.type(), methodInfo, this.defaultWorkerType));
        }
        return Optional.empty();
    }

    @Override
    public void start(ZeebeClient client) {
        this.zeebeWorkerValues.stream().peek(zeebeWorkerValue -> this.zeebeWorkerValueCustomizers.forEach(customizer -> customizer.customize((ZeebeWorkerValue)zeebeWorkerValue))).filter(ZeebeWorkerValue::getEnabled).forEach(zeebeWorkerValue -> this.jobWorkerManager.openWorker(client, (ZeebeWorkerValue)zeebeWorkerValue));
    }

    @Override
    public void stop(ZeebeClient zeebeClient) {
        this.jobWorkerManager.closeAllOpenWorkers();
    }
}

