/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback.filter;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.filter.LevelFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.logback.filter.FilterFactory;

@JsonTypeName(value="level")
public class LevelFilterFactory
extends FilterFactory {
    private String onMatch;
    private String onMismatch;

    public String getOnMatch() {
        return this.onMatch;
    }

    @BQConfigProperty(value="on match event policy (\"accept\", \"deny\" or \"neutral\")")
    public void setOnMatch(String onMatch) {
        this.onMatch = onMatch;
    }

    public String getOnMismatch() {
        return this.onMismatch;
    }

    @BQConfigProperty(value="on mismatch event policy (\"accept\", \"deny\" or \"neutral\")")
    public void setOnMismatch(String onMismatch) {
        this.onMismatch = onMismatch;
    }

    @Override
    public Filter<ILoggingEvent> createFilter() {
        return this.createLevelFilter();
    }

    protected LevelFilter createLevelFilter() {
        LevelFilter levelFilter = new LevelFilter();
        levelFilter.setLevel(Level.valueOf((String)this.getLevel()));
        levelFilter.setOnMatch(this.getFilterReply(this.getOnMatch()));
        levelFilter.setOnMismatch(this.getFilterReply(this.getOnMismatch()));
        levelFilter.setName("level");
        this.setType("level");
        levelFilter.start();
        return levelFilter;
    }

    public FilterReply getFilterReply(String string) {
        string = string.toUpperCase();
        for (FilterReply reply : FilterReply.values()) {
            if (!reply.toString().equals(string)) continue;
            return reply;
        }
        return FilterReply.NEUTRAL;
    }
}

