/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback.appender;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.logback.appender.AppenderFactory;
import io.bootique.logback.policy.RollingPolicyFactory;
import java.util.Objects;

@JsonTypeName(value="file")
public class FileAppenderFactory
extends AppenderFactory {
    private String file;
    private RollingPolicyFactory rollingPolicy;
    private boolean append = true;

    public String getFile() {
        return this.file;
    }

    @BQConfigProperty
    public void setFile(String file) {
        this.file = file;
    }

    public RollingPolicyFactory getRollingPolicy() {
        return this.rollingPolicy;
    }

    @BQConfigProperty
    public void setRollingPolicy(RollingPolicyFactory rollingPolicy) {
        this.rollingPolicy = rollingPolicy;
    }

    public boolean isAppend() {
        return this.append;
    }

    @BQConfigProperty
    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public Appender<ILoggingEvent> createAppender(LoggerContext context, String defaultLogFormat) {
        LayoutWrappingEncoder encoder = new LayoutWrappingEncoder();
        encoder.setLayout(this.createLayout(context, defaultLogFormat));
        FileAppender<ILoggingEvent> appender = this.rollingPolicy == null ? this.createSingleFileAppender((Encoder<ILoggingEvent>)encoder, context) : this.createRollingFileAppender((Encoder<ILoggingEvent>)encoder, context, this.rollingPolicy);
        appender.setName(this.getName());
        this.createFilters((Appender<ILoggingEvent>)appender);
        return this.asAsync((Appender<ILoggingEvent>)appender);
    }

    protected FileAppender<ILoggingEvent> createSingleFileAppender(Encoder<ILoggingEvent> encoder, LoggerContext context) {
        FileAppender appender = new FileAppender();
        appender.setFile(Objects.requireNonNull(this.file));
        appender.setContext((Context)context);
        appender.setEncoder(encoder);
        appender.setAppend(this.append);
        appender.start();
        return appender;
    }

    protected FileAppender<ILoggingEvent> createRollingFileAppender(Encoder<ILoggingEvent> encoder, LoggerContext context, RollingPolicyFactory rollingPolicy) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setFile(this.file);
        appender.setContext((Context)context);
        appender.setEncoder(encoder);
        appender.setAppend(this.append);
        RollingPolicy policy = rollingPolicy.createRollingPolicy(context);
        appender.setRollingPolicy(policy);
        policy.setParent((FileAppender)appender);
        TriggeringPolicy<ILoggingEvent> triggeringPolicy = rollingPolicy.createTriggeringPolicy(context);
        if (triggeringPolicy != null) {
            appender.setTriggeringPolicy(triggeringPolicy);
            triggeringPolicy.start();
        }
        policy.start();
        appender.start();
        return appender;
    }
}

