/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback.appender;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.logback.appender.AppenderFactory;
import io.bootique.logback.appender.ConsoleTarget;
import java.util.Objects;

@JsonTypeName(value="console")
@BQConfig(value="Appender that prints its output to stdout or stderr.")
public class ConsoleAppenderFactory
extends AppenderFactory {
    private ConsoleTarget target = ConsoleTarget.stdout;

    public ConsoleTarget getTarget() {
        return this.target;
    }

    @BQConfigProperty(value="Whether the log should be sent to stdout or stderr. The default is 'stdout'")
    public void setTarget(ConsoleTarget target) {
        this.target = Objects.requireNonNull(target);
    }

    @Override
    public Appender<ILoggingEvent> createAppender(LoggerContext context, String defaultLogFormat) {
        ConsoleAppender<ILoggingEvent> consoleAppender = this.createConsoleAppender(context, defaultLogFormat);
        consoleAppender.setName(this.getName());
        this.createFilters((Appender<ILoggingEvent>)consoleAppender);
        return this.asAsync((Appender<ILoggingEvent>)consoleAppender);
    }

    protected ConsoleAppender<ILoggingEvent> createConsoleAppender(LoggerContext context, String defaultLogFormat) {
        ConsoleAppender appender = new ConsoleAppender();
        appender.setName("console");
        appender.setContext((Context)context);
        appender.setTarget(this.target.getLogbackTarget());
        LayoutWrappingEncoder layoutEncoder = new LayoutWrappingEncoder();
        layoutEncoder.setLayout(this.createLayout(context, defaultLogFormat));
        appender.setEncoder((Encoder)layoutEncoder);
        appender.start();
        return appender;
    }
}

