/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback.appender;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.config.PolymorphicConfiguration;
import io.bootique.logback.appender.ConsoleAppenderFactory;
import io.bootique.logback.filter.FilterFactory;
import io.bootique.logback.layout.LayoutFactory;
import io.bootique.logback.layout.PatternLayoutFactory;
import java.util.Collection;

@BQConfig(value="Appender of a given type.")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=ConsoleAppenderFactory.class)
public abstract class AppenderFactory
implements PolymorphicConfiguration {
    private String logFormat;
    private String name;
    private LayoutFactory layout;
    private Collection<FilterFactory> filters;

    public String getLogFormat() {
        return this.logFormat;
    }

    @BQConfigProperty(value="Log format specification compatible with Logback framework. If not set, the value is propagated from the parent configuration.")
    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    public abstract Appender<ILoggingEvent> createAppender(LoggerContext var1, String var2);

    public LayoutFactory getLayout() {
        return this.layout;
    }

    @BQConfigProperty(value="Layout for log message.")
    public void setLayout(LayoutFactory layout) {
        this.layout = layout;
    }

    public String getName() {
        return this.name;
    }

    @BQConfigProperty(value="Appender name.")
    public void setName(String name) {
        this.name = name;
    }

    public Collection<FilterFactory> getFilters() {
        return this.filters;
    }

    @BQConfigProperty(value="Collection of Logback filters")
    public void setFilters(Collection<FilterFactory> filters) {
        this.filters = filters;
    }

    protected Appender<ILoggingEvent> createFilters(Appender<ILoggingEvent> appender) {
        if (this.filters != null) {
            this.filters.forEach(filter -> appender.addFilter(filter.createFilter()));
        }
        return appender;
    }

    protected Layout<ILoggingEvent> createLayout(LoggerContext context, String defaultLogFormat) {
        Layout<ILoggingEvent> currentLayout;
        String logFormat;
        String string = logFormat = this.logFormat != null ? this.logFormat : defaultLogFormat;
        if (this.layout == null) {
            this.layout = new PatternLayoutFactory();
        }
        if (!(currentLayout = this.layout.createLayout(context, logFormat)).isStarted()) {
            throw new RuntimeException("Layout isn't configured for starting : " + currentLayout);
        }
        return currentLayout;
    }

    protected Appender<ILoggingEvent> asAsync(Appender<ILoggingEvent> appender) {
        return this.asAsync(appender, appender.getContext());
    }

    protected Appender<ILoggingEvent> asAsync(Appender<ILoggingEvent> appender, Context context) {
        AsyncAppender asyncAppender = new AsyncAppender();
        asyncAppender.setIncludeCallerData(false);
        asyncAppender.setQueueSize(256);
        asyncAppender.setDiscardingThreshold(-1);
        asyncAppender.setContext(context);
        asyncAppender.setName(appender.getName());
        asyncAppender.addAppender(appender);
        asyncAppender.start();
        return asyncAppender;
    }
}

