/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.logback.LogbackLevel;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@BQConfig
public class LoggerFactory {
    private LogbackLevel level;
    private Collection<String> appenderRefs = Collections.emptyList();

    public LoggerFactory() {
        this.level = LogbackLevel.info;
    }

    public LogbackLevel getLevel() {
        return this.level;
    }

    @BQConfigProperty(value="Logging level of a given logger and its children.")
    public void setLevel(LogbackLevel level) {
        this.level = level;
    }

    public void configLogger(Logger logger, Map<String, Appender<ILoggingEvent>> namedAppenders, Collection<Appender<ILoggingEvent>> anonymousAppenders) {
        logger.setLevel(Level.toLevel((String)this.level.name(), (Level)Level.INFO));
        this.appenderRefs.forEach(ar -> this.configLoggerAppender(logger, (String)ar, namedAppenders));
        anonymousAppenders.forEach(arg_0 -> ((Logger)logger).addAppender(arg_0));
    }

    private void configLoggerAppender(Logger logger, String appenderName, Map<String, Appender<ILoggingEvent>> appenders) {
        Appender<ILoggingEvent> appender = appenders.get(appenderName);
        if (appender == null) {
            throw new IllegalStateException("Invalid appender reference '" + appenderName + "'. No appender configuration exists for this name");
        }
        logger.addAppender(appender);
    }

    public Collection<String> getAppenderRefs() {
        return this.appenderRefs;
    }

    @BQConfigProperty(value="Collection of references to named appenders")
    public void setAppenderRefs(Collection<String> appenderRefs) {
        this.appenderRefs = appenderRefs;
    }
}

