/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback;

import ch.qos.logback.classic.Logger;
import io.bootique.ConfigModule;
import io.bootique.annotation.LogLevels;
import io.bootique.config.ConfigurationFactory;
import io.bootique.di.Binder;
import io.bootique.di.Provides;
import io.bootique.logback.LogbackContextFactory;
import io.bootique.shutdown.ShutdownManager;
import java.util.Map;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Singleton;

public class LogbackModule
extends ConfigModule {
    protected String defaultConfigPrefix() {
        return "log";
    }

    public void configure(Binder binder) {
        binder.bind(LogInitTrigger.class).initOnStartup();
    }

    @Singleton
    @Provides
    Logger provideRootLogger(ConfigurationFactory configFactory, ShutdownManager shutdownManager, @LogLevels Map<String, Level> defaultLevels) {
        return ((LogbackContextFactory)this.config(LogbackContextFactory.class, configFactory)).createRootLogger(shutdownManager, defaultLevels);
    }

    static class LogInitTrigger {
        @Inject
        public LogInitTrigger(Logger rootLogger) {
            rootLogger.debug("Logback started");
        }
    }
}

