/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.server;

import io.bootique.annotation.BQConfig;
import io.bootique.jetty.MappedFilter;
import io.bootique.jetty.server.WebArtifactFactory;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BQConfig
public class FilterFactory
extends WebArtifactFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterFactory.class);

    public Optional<FilterHolder> createAndAddJettyFilter(ServletContextHandler handler, MappedFilter mappedFilter) {
        Map<String, String> params;
        Objects.requireNonNull(mappedFilter.getFilter());
        Set<String> urlPatterns = this.getUrlPatterns(mappedFilter.getUrlPatterns());
        if (urlPatterns.isEmpty()) {
            LOGGER.info("Skipping unmapped filter {}", (Object)mappedFilter.getFilter().getClass().getName());
            return Optional.empty();
        }
        FilterHolder holder = new FilterHolder(mappedFilter.getFilter());
        if (mappedFilter.getName() != null) {
            holder.setName(mappedFilter.getName());
        }
        if ((params = this.getParams(mappedFilter.getParams())) != null) {
            params.forEach((k, v) -> holder.setInitParameter(k, v));
        }
        EnumSet<DispatcherType> dispatches = EnumSet.of(DispatcherType.REQUEST);
        urlPatterns.forEach(urlPattern -> {
            if (LOGGER.isInfoEnabled()) {
                String name = mappedFilter.getName() != null ? mappedFilter.getName() : "?";
                LOGGER.info("Adding filter '{}' mapped to {}", (Object)name, urlPattern);
            }
            handler.addFilter(holder, urlPattern, dispatches);
        });
        return Optional.of(holder);
    }
}

