/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jetty.server.NetworkConnector;

public class ConnectorHolder {
    private NetworkConnector connector;

    public ConnectorHolder(NetworkConnector connector) {
        this.connector = connector;
    }

    public String getUrl(String context) {
        String protocol = this.getProtocol();
        String host = this.getHost();
        int port = this.resolveNonDefaultPort(protocol);
        StringBuilder url = new StringBuilder(protocol).append("://").append(host);
        if (port > 0) {
            url.append(":").append(port);
        }
        if (!"/".equals(context)) {
            url.append(context);
        }
        return url.toString();
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public String getHost() {
        if (this.connector.getHost() != null) {
            return this.connector.getHost();
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Error getting localhost", e);
        }
    }

    public String getProtocol() {
        for (String protocol : this.connector.getProtocols()) {
            if (!"ssl".equals(protocol)) continue;
            return "https";
        }
        return "http";
    }

    private int resolveNonDefaultPort(String protocol) {
        int port = this.connector.getPort();
        if (port == 80 && "http".equals(protocol)) {
            return 0;
        }
        if (port == 443 && "https".equals(protocol)) {
            return 0;
        }
        return port;
    }
}

