/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.connector;

import com.fasterxml.jackson.annotation.JsonValue;
import io.bootique.jetty.connector.PortFinder;

public class PortFactory {
    private static final String ANY_PORT_LABEL = "any";
    static final int DEFAULT_PORT = 8080;
    private String portString;
    private int port;

    public PortFactory(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("Port must be a positive integer: " + this.portString);
        }
        this.port = port;
    }

    public PortFactory(String portString) {
        this.portString = portString;
    }

    @JsonValue
    public String getPortString() {
        return this.portString;
    }

    public int resolve(String host) {
        if (this.port > 0) {
            return this.port;
        }
        if (this.portString == null || this.portString.isEmpty()) {
            return 8080;
        }
        if (ANY_PORT_LABEL.equals(this.portString)) {
            return this.findAvailablePort(host);
        }
        return this.resolveExplicitPort();
    }

    protected int findAvailablePort(String host) {
        return PortFinder.findAvailablePort(host);
    }

    protected int resolveExplicitPort() {
        int port;
        try {
            port = Integer.parseInt(this.portString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid port. Must be either a positive integer or a keyword 'dynamic': " + this.portString);
        }
        if (port <= 0) {
            throw new IllegalArgumentException("Port must be a positive integer: " + this.portString);
        }
        return port;
    }
}

