/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.connector;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.config.PolymorphicConfiguration;
import io.bootique.jetty.connector.HttpConnectorFactory;
import io.bootique.jetty.connector.PortFactory;
import io.bootique.value.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

@BQConfig
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=HttpConnectorFactory.class)
public abstract class ConnectorFactory
implements PolymorphicConfiguration {
    private int acceptorThreads;
    private int selectorThreads;
    private PortFactory port;
    private String host;
    private int responseHeaderSize = 8192;
    private int requestHeaderSize = 8192;
    private Duration idleTimeout;
    private boolean sendServerVersion;

    public ServerConnector createConnector(Server server) {
        HttpConfiguration httpConfig = this.buildHttpConfiguration();
        ConnectionFactory[] connectionFactories = this.buildHttpConnectionFactories(httpConfig);
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        ByteBufferPool bufferPool = this.buildBufferPool();
        int acceptorThreads = this.acceptorThreads > 0 ? this.acceptorThreads : -1;
        int selectorThreads = this.selectorThreads > 0 ? this.selectorThreads : -1;
        ThreadPool threadPool = Objects.requireNonNull(server.getThreadPool());
        ServerConnector connector = new ServerConnector(server, (Executor)threadPool, (Scheduler)scheduler, bufferPool, acceptorThreads, selectorThreads, connectionFactories);
        connector.setPort(this.resolvePort());
        connector.setIdleTimeout(this.getIdleTimeoutMs());
        String host = "*".equals(this.host) ? "0.0.0.0" : this.host;
        connector.setHost(host);
        return connector;
    }

    protected long getIdleTimeoutMs() {
        return this.idleTimeout != null ? this.idleTimeout.getDuration().toMillis() : 30000L;
    }

    protected abstract ConnectionFactory[] buildHttpConnectionFactories(HttpConfiguration var1);

    protected HttpConfiguration buildHttpConfiguration() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setHeaderCacheSize(512);
        httpConfig.setOutputBufferSize(32768);
        httpConfig.setRequestHeaderSize(this.requestHeaderSize);
        httpConfig.setResponseHeaderSize(this.responseHeaderSize);
        httpConfig.setSendDateHeader(true);
        httpConfig.setSendServerVersion(this.sendServerVersion);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        return httpConfig;
    }

    protected ByteBufferPool buildBufferPool() {
        return new ArrayByteBufferPool(64, 1024, 65536);
    }

    protected int resolvePort() {
        return this.port != null ? this.port.resolve(this.getHost()) : 8080;
    }

    public PortFactory getPort() {
        return this.port;
    }

    @BQConfigProperty(value="Connector listen port. Can be either a positive integer or a string 'any'. The latter would cause Jetty to listen on an arbitrary available port determined during startup")
    public void setPort(PortFactory port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    @BQConfigProperty
    public void setHost(String host) {
        this.host = host;
    }

    public int getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    @BQConfigProperty
    public void setRequestHeaderSize(int requestHeaderSize) {
        this.requestHeaderSize = requestHeaderSize;
    }

    public int getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    @BQConfigProperty
    public void setResponseHeaderSize(int responseHeaderSize) {
        this.responseHeaderSize = responseHeaderSize;
    }

    public int getAcceptorThreads() {
        return this.acceptorThreads;
    }

    @BQConfigProperty(value="A desired number of acceptor threads. If not provided, Jetty will calculate an optimal value based on the number of available processor cores.")
    public void setAcceptorThreads(int acceptorThreads) {
        this.acceptorThreads = acceptorThreads;
    }

    public int getSelectorThreads() {
        return this.selectorThreads;
    }

    @BQConfigProperty(value="A desired number of selector threads. If not provided, Jetty will calculate an optimal value based on the number of available processor cores.")
    public void setSelectorThreads(int selectorThreads) {
        this.selectorThreads = selectorThreads;
    }

    @BQConfigProperty
    public void setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public boolean isSendServerVersion() {
        return this.sendServerVersion;
    }

    @BQConfigProperty(value="Property to include server version header in responses.")
    public void setSendServerVersion(boolean sendServerVersion) {
        this.sendServerVersion = sendServerVersion;
    }
}

