/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.pipeline;

import io.awspring.cloud.sqs.CompletableFutures;
import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.AsyncMessageListener;
import io.awspring.cloud.sqs.listener.ListenerExecutionFailedException;
import io.awspring.cloud.sqs.listener.MessageProcessingContext;
import io.awspring.cloud.sqs.listener.pipeline.MessageProcessingConfiguration;
import io.awspring.cloud.sqs.listener.pipeline.MessageProcessingPipeline;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;

public class MessageListenerExecutionStage<T>
implements MessageProcessingPipeline<T> {
    private static final Logger logger = LoggerFactory.getLogger(MessageListenerExecutionStage.class);
    private final AsyncMessageListener<T> messageListener;

    public MessageListenerExecutionStage(MessageProcessingConfiguration<T> configuration) {
        this.messageListener = configuration.getMessageListener();
    }

    @Override
    public CompletableFuture<Message<T>> process(Message<T> message, MessageProcessingContext<T> context) {
        logger.trace("Processing message {}", (Object)MessageHeaderUtils.getId(message));
        return CompletableFutures.exceptionallyCompose(this.messageListener.onMessage(message).thenApply(theVoid -> message), t -> CompletableFutures.failedFuture(ListenerExecutionFailedException.hasListenerException(t) ? t : new ListenerExecutionFailedException("Listener failed to process message", (Throwable)t, message)));
    }

    @Override
    public CompletableFuture<Collection<Message<T>>> process(Collection<Message<T>> messages, MessageProcessingContext<T> context) {
        logger.trace("Processing messages {}", (Object)MessageHeaderUtils.getId(messages));
        return CompletableFutures.exceptionallyCompose(this.messageListener.onMessage(messages).thenApply(theVoid -> messages), t -> CompletableFutures.failedFuture(ListenerExecutionFailedException.hasListenerException(t) ? t : new ListenerExecutionFailedException("Listener failed to process messages", (Throwable)t, messages)));
    }
}

