/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener.adapter;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.ListenerExecutionFailedException;
import java.util.Collection;
import java.util.Collections;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public abstract class AbstractMethodInvokingListenerAdapter<T> {
    private final InvocableHandlerMethod handlerMethod;

    protected AbstractMethodInvokingListenerAdapter(InvocableHandlerMethod handlerMethod) {
        Assert.notNull((Object)handlerMethod, (String)"handlerMethod cannot be null");
        this.handlerMethod = handlerMethod;
    }

    protected final Object invokeHandler(Message<T> message) {
        try {
            return this.handlerMethod.invoke(message, new Object[0]);
        }
        catch (Exception e) {
            throw this.createListenerException(message, (Throwable)e);
        }
    }

    protected final Object invokeHandler(Collection<Message<T>> messages) {
        try {
            return this.handlerMethod.invoke(MessageBuilder.withPayload(messages).build(), new Object[0]);
        }
        catch (Exception e) {
            throw this.createListenerException(messages, (Throwable)e);
        }
    }

    protected ListenerExecutionFailedException createListenerException(Collection<Message<T>> messages, Throwable t) {
        return new ListenerExecutionFailedException("Listener failed to process messages " + MessageHeaderUtils.getId(messages), t, messages);
    }

    protected ListenerExecutionFailedException createListenerException(Message<T> message, Throwable t) {
        return this.createListenerException(Collections.singletonList(message), t);
    }
}

