/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.listener;

import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementCallback;
import io.awspring.cloud.sqs.listener.interceptor.AsyncMessageInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageProcessingContext<T> {
    private final List<AsyncMessageInterceptor<T>> interceptors;
    private final Runnable backPressureReleaseCallback;
    private final AcknowledgementCallback<T> acknowledgementCallback;

    private MessageProcessingContext(List<AsyncMessageInterceptor<T>> interceptors, Runnable backPressureReleaseCallback, AcknowledgementCallback<T> acknowledgementCallback) {
        this.interceptors = Collections.unmodifiableList(interceptors);
        this.backPressureReleaseCallback = backPressureReleaseCallback;
        this.acknowledgementCallback = acknowledgementCallback;
    }

    public MessageProcessingContext<T> addInterceptor(AsyncMessageInterceptor<T> interceptor) {
        ArrayList<AsyncMessageInterceptor<T>> contextInterceptors = new ArrayList<AsyncMessageInterceptor<T>>(this.interceptors);
        contextInterceptors.add(interceptor);
        return new MessageProcessingContext<T>(contextInterceptors, this.backPressureReleaseCallback, this.acknowledgementCallback);
    }

    public MessageProcessingContext<T> setBackPressureReleaseCallback(Runnable backPressureReleaseCallback) {
        return new MessageProcessingContext<T>(this.interceptors, backPressureReleaseCallback, this.acknowledgementCallback);
    }

    public MessageProcessingContext<T> setAcknowledgmentCallback(AcknowledgementCallback<T> acknowledgementCallback) {
        return new MessageProcessingContext<T>(this.interceptors, this.backPressureReleaseCallback, acknowledgementCallback);
    }

    public List<AsyncMessageInterceptor<T>> getInterceptors() {
        return this.interceptors;
    }

    public void runBackPressureReleaseCallback() {
        this.backPressureReleaseCallback.run();
    }

    public AcknowledgementCallback<T> getAcknowledgmentCallback() {
        return this.acknowledgementCallback;
    }

    public static <T> MessageProcessingContext<T> create() {
        return new MessageProcessingContext<T>(Collections.emptyList(), () -> {}, new AcknowledgementCallback<T>(){});
    }
}

