/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs;

import io.awspring.cloud.sqs.CompletableFutures;
import io.awspring.cloud.sqs.QueueAttributesResolvingException;
import io.awspring.cloud.sqs.listener.QueueAttributes;
import io.awspring.cloud.sqs.listener.QueueNotFoundStrategy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.QueueDoesNotExistException;

public class QueueAttributesResolver {
    private static final Logger logger = LoggerFactory.getLogger(QueueAttributesResolver.class);
    private final String queueName;
    private final SqsAsyncClient sqsAsyncClient;
    private final Collection<QueueAttributeName> queueAttributeNames;
    private final QueueNotFoundStrategy queueNotFoundStrategy;

    private QueueAttributesResolver(Builder builder) {
        this.queueName = builder.queueName;
        this.sqsAsyncClient = builder.sqsAsyncClient;
        this.queueAttributeNames = builder.queueAttributeNames;
        this.queueNotFoundStrategy = builder.queueNotFoundStrategy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompletableFuture<QueueAttributes> resolveQueueAttributes() {
        logger.debug("Resolving attributes for queue {}", (Object)this.queueName);
        return CompletableFutures.exceptionallyCompose(this.resolveQueueUrl().thenCompose(queueUrl -> this.getQueueAttributes((String)queueUrl).thenApply(queueAttributes -> new QueueAttributes(this.queueName, (String)queueUrl, (Map<QueueAttributeName, String>)queueAttributes))), this::wrapException);
    }

    private CompletableFuture<QueueAttributes> wrapException(Throwable t) {
        return CompletableFutures.failedFuture(new QueueAttributesResolvingException("Error resolving attributes for queue " + this.queueName + " with strategy " + this.queueNotFoundStrategy + " and queueAttributesNames " + this.queueAttributeNames, t instanceof CompletionException ? t.getCause() : t));
    }

    private CompletableFuture<String> resolveQueueUrl() {
        return this.isValidQueueUrl(this.queueName) ? CompletableFuture.completedFuture(this.queueName) : this.doResolveQueueUrl();
    }

    private CompletableFuture<String> doResolveQueueUrl() {
        GetQueueUrlRequest.Builder getQueueUrlRequestBuilder = GetQueueUrlRequest.builder();
        Arn arn = this.getQueueArnFromUrl();
        if (arn != null) {
            Assert.isTrue((boolean)arn.accountId().isPresent(), (String)"accountId is missing from arn");
            getQueueUrlRequestBuilder.queueName(arn.resourceAsString()).queueOwnerAWSAccountId((String)arn.accountId().get());
        } else {
            getQueueUrlRequestBuilder.queueName(this.queueName);
        }
        return CompletableFutures.exceptionallyCompose(this.sqsAsyncClient.getQueueUrl((GetQueueUrlRequest)getQueueUrlRequestBuilder.build()).thenApply(GetQueueUrlResponse::queueUrl), this::handleException);
    }

    private CompletableFuture<String> handleException(Throwable t) {
        return t.getCause() instanceof QueueDoesNotExistException && QueueNotFoundStrategy.CREATE.equals((Object)this.queueNotFoundStrategy) ? this.createQueue() : CompletableFutures.failedFuture(t);
    }

    private CompletableFuture<String> createQueue() {
        return ((CompletableFuture)this.sqsAsyncClient.createQueue(req -> req.queueName(this.queueName).build()).thenApply(CreateQueueResponse::queueUrl)).whenComplete(this::logCreateQueueResult);
    }

    private void logCreateQueueResult(String v, Throwable t) {
        if (t != null) {
            logger.debug("Error creating queue {}", (Object)this.queueName, (Object)t);
            return;
        }
        logger.debug("Created queue {} with url {}", (Object)this.queueName, (Object)v);
    }

    private CompletableFuture<Map<QueueAttributeName, String>> getQueueAttributes(String queueUrl) {
        return this.queueAttributeNames.isEmpty() ? CompletableFuture.completedFuture(Collections.emptyMap()) : this.doGetAttributes(queueUrl);
    }

    private CompletableFuture<Map<QueueAttributeName, String>> doGetAttributes(String queueUrl) {
        logger.debug("Resolving attributes {} for queue {}", this.queueAttributeNames, (Object)this.queueName);
        return ((CompletableFuture)this.sqsAsyncClient.getQueueAttributes(req -> req.queueUrl(queueUrl).attributeNames(this.queueAttributeNames)).thenApply(GetQueueAttributesResponse::attributes)).whenComplete((v, t) -> logger.debug("Attributes for queue {} resolved", (Object)this.queueName));
    }

    private boolean isValidQueueUrl(String name) {
        try {
            URI candidate = new URI(name);
            return "http".equals(candidate.getScheme()) || "https".equals(candidate.getScheme());
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @Nullable
    private Arn getQueueArnFromUrl() {
        try {
            return Arn.fromString((String)this.queueName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static class Builder {
        private String queueName;
        private SqsAsyncClient sqsAsyncClient;
        private Collection<QueueAttributeName> queueAttributeNames;
        private QueueNotFoundStrategy queueNotFoundStrategy;

        public Builder queueName(String queueName) {
            Assert.notNull((Object)queueName, (String)"queueName cannot be null");
            this.queueName = queueName;
            return this;
        }

        public Builder sqsAsyncClient(SqsAsyncClient sqsAsyncClient) {
            Assert.notNull((Object)sqsAsyncClient, (String)"sqsAsyncClient cannot be null");
            this.sqsAsyncClient = sqsAsyncClient;
            return this;
        }

        public Builder queueAttributeNames(Collection<QueueAttributeName> queueAttributeNames) {
            Assert.notNull(queueAttributeNames, (String)"queueAttributeNames cannot be null");
            this.queueAttributeNames = queueAttributeNames;
            return this;
        }

        public Builder queueNotFoundStrategy(QueueNotFoundStrategy queueNotFoundStrategy) {
            Assert.notNull((Object)((Object)queueNotFoundStrategy), (String)"queueNotFoundStrategy cannot be null");
            this.queueNotFoundStrategy = queueNotFoundStrategy;
            return this;
        }

        public QueueAttributesResolver build() {
            Assert.noNullElements(Arrays.asList(new Object[]{this.queueAttributeNames, this.queueNotFoundStrategy, this.queueName, this.sqsAsyncClient}), (String)"Incomplete configuration for QueueAttributesResolver - null attributes found");
            return new QueueAttributesResolver(this);
        }
    }
}

