/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.services.receiveemail;

import io.automatiko.engine.addons.services.receiveemail.Attachment;
import io.automatiko.engine.addons.services.receiveemail.EmailMessage;
import io.automatiko.engine.api.io.InputConverter;
import jakarta.activation.DataHandler;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.mail.Address;
import jakarta.mail.Message;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.TypeConversionException;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.component.mail.MailMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class EmailInputConverter
implements InputConverter<EmailMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailInputConverter.class);

    public EmailMessage convert(Object input) {
        if (input instanceof MailMessage) {
            MailMessage mailMessage = (MailMessage)input;
            try {
                Map attachments;
                EmailMessage email = new EmailMessage();
                email.setFrom(this.toStringAddress(mailMessage.getOriginalMessage().getFrom()));
                email.setReplyTo(this.toStringAddress(mailMessage.getOriginalMessage().getReplyTo()));
                email.setTo(this.toSimpleAddress(mailMessage.getOriginalMessage().getRecipients(Message.RecipientType.TO)));
                email.setCc(this.toSimpleAddress(mailMessage.getOriginalMessage().getRecipients(Message.RecipientType.CC)));
                email.setBcc(this.toSimpleAddress(mailMessage.getOriginalMessage().getRecipients(Message.RecipientType.BCC)));
                email.setSubject(mailMessage.getOriginalMessage().getSubject());
                email.setBody((String)mailMessage.getBody(String.class));
                AttachmentMessage attachmentMessage = (AttachmentMessage)mailMessage.getExchange().getMessage(AttachmentMessage.class);
                if (attachmentMessage != null && (attachments = attachmentMessage.getAttachments()) != null && attachments.size() > 0) {
                    for (String name : attachments.keySet()) {
                        DataHandler dh = (DataHandler)attachments.get(name);
                        String filename = dh.getName();
                        try {
                            byte[] data = (byte[])mailMessage.getExchange().getContext().getTypeConverter().convertTo(byte[].class, (Object)dh.getInputStream());
                            email.addAttachment(new Attachment(filename, data));
                        }
                        catch (IOException | TypeConversionException e) {
                            LOGGER.warn("Unexpected excheption while reading email attachment {}", (Object)filename, (Object)e);
                        }
                    }
                }
                return email;
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected excheption while reading email message {}", (Throwable)e);
            }
        }
        return null;
    }

    protected List<String> toSimpleAddress(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return Collections.emptyList();
        }
        return Stream.of(addresses).map(a -> a.toString()).collect(Collectors.toList());
    }

    protected String toStringAddress(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        return addresses[0].toString();
    }
}

