/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.services.receiveemail;

import io.automatiko.engine.addons.services.receiveemail.Attachment;
import io.automatiko.engine.api.io.InputConverter;
import io.automatiko.engine.workflow.file.ByteArrayFile;
import jakarta.activation.DataHandler;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.TypeConversionException;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.component.mail.MailMessage;

@ApplicationScoped
public class EmailAttachmentsInputConverter
implements InputConverter<List<ByteArrayFile>> {
    public List<ByteArrayFile> convert(Object input) {
        ArrayList<ByteArrayFile> files = new ArrayList<ByteArrayFile>();
        if (input instanceof MailMessage) {
            Map attachments;
            MailMessage mailMessage = (MailMessage)input;
            mailMessage.getMessageId();
            AttachmentMessage attachmentMessage = (AttachmentMessage)mailMessage.getExchange().getMessage(AttachmentMessage.class);
            if (attachmentMessage != null && (attachments = attachmentMessage.getAttachments()) != null && attachments.size() > 0) {
                for (String name : attachments.keySet()) {
                    DataHandler dh = (DataHandler)attachments.get(name);
                    String filename = dh.getName();
                    try {
                        byte[] data = (byte[])mailMessage.getExchange().getContext().getTypeConverter().convertTo(byte[].class, (Object)dh.getInputStream());
                        files.add(new Attachment(filename, data));
                    }
                    catch (IOException | TypeConversionException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return files;
    }
}

