/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.services.receiveemail;

import io.automatiko.engine.addons.services.receiveemail.Attachment;
import io.automatiko.engine.api.io.InputConverter;
import io.automatiko.engine.workflow.file.ByteArrayFile;
import jakarta.activation.DataHandler;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.util.Map;
import org.apache.camel.TypeConversionException;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.component.mail.MailMessage;

@ApplicationScoped
public class EmailAttachmentInputConverter
implements InputConverter<ByteArrayFile> {
    public ByteArrayFile convert(Object input) {
        Map attachments;
        MailMessage mailMessage;
        AttachmentMessage attachmentMessage;
        if (input instanceof MailMessage && (attachmentMessage = (AttachmentMessage)(mailMessage = (MailMessage)input).getExchange().getMessage(AttachmentMessage.class)) != null && (attachments = attachmentMessage.getAttachments()) != null && attachments.size() > 0) {
            for (String name : attachments.keySet()) {
                DataHandler dh = (DataHandler)attachments.get(name);
                String filename = dh.getName();
                try {
                    byte[] data = (byte[])mailMessage.getExchange().getContext().getTypeConverter().convertTo(byte[].class, (Object)dh.getInputStream());
                    return new Attachment(filename, data);
                }
                catch (IOException | TypeConversionException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

