/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addons.usertasks.index.fs;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleNullableAttribute;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.option.AttributeOrder;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.common.NoSuchObjectException;
import io.automatiko.addon.usertasks.index.UserTask;
import io.automatiko.addon.usertasks.index.UserTaskIndexResource;
import io.automatiko.addons.usertasks.index.fs.CQEngineBasedIndex;
import io.automatiko.addons.usertasks.index.fs.CQEngineCustomQueryBuilder;
import io.automatiko.addons.usertasks.index.fs.CQEngineUserTaskInfo;
import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.auth.IdentitySupplier;
import io.automatiko.engine.api.runtime.process.WorkItemNotFoundException;
import io.quarkus.arc.All;
import jakarta.inject.Inject;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CQEngineUserTaskIndexResource
implements UserTaskIndexResource {
    private CQEngineBasedIndex index;
    private IdentitySupplier identitySupplier;
    private Map<String, CQEngineCustomQueryBuilder> customQueries = new HashMap<String, CQEngineCustomQueryBuilder>();

    @Inject
    public CQEngineUserTaskIndexResource(CQEngineBasedIndex index, IdentitySupplier identitySupplier, @All List<CQEngineCustomQueryBuilder> queries) {
        this.identitySupplier = identitySupplier;
        this.index = index;
        queries.stream().forEach(q -> this.customQueries.put(q.id(), (CQEngineCustomQueryBuilder)q));
    }

    public Collection<? extends UserTask> findTasks(String name, String description, String state, String priority, int page, int size, String sortBy, boolean sortAsc, String user, List<String> groups) {
        IdentityProvider identityProvider = this.identitySupplier.buildIdentityProvider(user, groups);
        if (identityProvider.getName() == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> conditions = new ArrayList<Object>();
        conditions.add(QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.in(CQEngineUserTaskInfo.POT_OWNERS, (Object[])new Object[]{identityProvider.getName()}), (Query)QueryFactory.in(CQEngineUserTaskInfo.POT_GROUPS, (boolean)false, (Collection)identityProvider.getRoles()), (Query)QueryFactory.and((Query)QueryFactory.not((Query)QueryFactory.has(CQEngineUserTaskInfo.POT_OWNERS)), (Query)QueryFactory.not((Query)QueryFactory.has(CQEngineUserTaskInfo.POT_OWNERS)))), (Query)QueryFactory.not((Query)QueryFactory.in(CQEngineUserTaskInfo.EXCLUDED_USERS, (Object[])new Object[]{identityProvider.getName()}))));
        if (name != null) {
            conditions.add(QueryFactory.contains(CQEngineUserTaskInfo.TASK_NAME, (CharSequence)name));
        }
        if (description != null) {
            conditions.add(QueryFactory.contains(CQEngineUserTaskInfo.TASK_DESCRIPTION, (CharSequence)description));
        }
        if (state != null) {
            conditions.add(QueryFactory.equal(CQEngineUserTaskInfo.TASK_STATE, (Object)state));
        }
        if (priority != null) {
            conditions.add(QueryFactory.equal(CQEngineUserTaskInfo.TASK_PRIORITY, (Object)priority));
        }
        QueryOptions queryOptions = null;
        if (sortBy != null) {
            queryOptions = QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)(sortAsc ? QueryFactory.ascending(this.sortAttribute(sortBy)) : QueryFactory.descending(this.sortAttribute(sortBy)))));
        }
        And query = conditions.size() > 1 ? new And(conditions) : (Query)conditions.get(0);
        try {
            List list;
            block15: {
                ResultSet resultSet = this.index.get().retrieve((Query)query, queryOptions);
                try {
                    list = resultSet.stream().skip(this.calculatePage(page, size)).limit(size).toList();
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    public UserTask findTask(String id, String user, List<String> groups) {
        IdentityProvider identityProvider = this.identitySupplier.buildIdentityProvider(user, groups);
        And query = QueryFactory.and((Query)QueryFactory.equal(CQEngineUserTaskInfo.TASK_ID, (Object)id), (Query)QueryFactory.or((Query)QueryFactory.in(CQEngineUserTaskInfo.POT_OWNERS, (Object[])new Object[]{identityProvider.getName()}), (Query)QueryFactory.in(CQEngineUserTaskInfo.POT_GROUPS, (boolean)false, (Collection)identityProvider.getRoles()), (Query)QueryFactory.and((Query)QueryFactory.not((Query)QueryFactory.has(CQEngineUserTaskInfo.POT_OWNERS)), (Query)QueryFactory.not((Query)QueryFactory.has(CQEngineUserTaskInfo.POT_OWNERS)))));
        try {
            UserTask userTask;
            block11: {
                ResultSet resultSet = this.index.get().retrieve((Query)query);
                try {
                    userTask = (UserTask)resultSet.uniqueResult();
                    if (resultSet == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchObjectException e) {
                        throw new WorkItemNotFoundException("User task with given id was not found", id);
                    }
                }
                resultSet.close();
            }
            return userTask;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    public Collection<? extends UserTask> queryTasks(UriInfo uriInfo, String name, int page, int size, String sortBy, boolean sortAsc, String user, List<String> groups) {
        CQEngineCustomQueryBuilder customQuery = this.customQueries.get(name);
        if (customQuery == null) {
            throw new NotFoundException("Query with id '" + name + "' was not registered");
        }
        IdentityProvider identityProvider = this.identitySupplier.buildIdentityProvider(user, groups);
        ArrayList<Object> conditions = new ArrayList<Object>();
        conditions.add(QueryFactory.and((Query)QueryFactory.or((Query)QueryFactory.in(CQEngineUserTaskInfo.POT_OWNERS, (Object[])new Object[]{identityProvider.getName()}), (Query)QueryFactory.in(CQEngineUserTaskInfo.POT_GROUPS, (boolean)false, (Collection)identityProvider.getRoles()), (Query)QueryFactory.and((Query)QueryFactory.not((Query)QueryFactory.has(CQEngineUserTaskInfo.POT_OWNERS)), (Query)QueryFactory.not((Query)QueryFactory.has(CQEngineUserTaskInfo.POT_OWNERS)))), (Query)QueryFactory.not((Query)QueryFactory.in(CQEngineUserTaskInfo.EXCLUDED_USERS, (Object[])new Object[]{identityProvider.getName()}))));
        Query filter = (Query)customQuery.build((Map)uriInfo.getQueryParameters());
        conditions.add(filter);
        QueryOptions queryOptions = null;
        if (sortBy != null) {
            queryOptions = QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)(sortAsc ? QueryFactory.ascending(this.sortAttribute(sortBy)) : QueryFactory.descending(this.sortAttribute(sortBy)))));
        }
        And query = conditions.size() > 1 ? new And(conditions) : (Query)conditions.get(0);
        try {
            List list;
            block11: {
                ResultSet resultSet = this.index.get().retrieve((Query)query, queryOptions);
                try {
                    list = resultSet.stream().skip(this.calculatePage(page, size)).limit(size).toList();
                    if (resultSet == null) break block11;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    protected int calculatePage(int page, int size) {
        if (page <= 1) {
            return 0;
        }
        return (page - 1) * size;
    }

    protected Attribute<CQEngineUserTaskInfo, ? extends Comparable> sortAttribute(String name) {
        SimpleNullableAttribute<CQEngineUserTaskInfo, String> sortAttribute = null;
        switch (name.toLowerCase()) {
            case "taskName": 
            case "name": {
                sortAttribute = CQEngineUserTaskInfo.TASK_NAME;
                break;
            }
            case "id": {
                sortAttribute = CQEngineUserTaskInfo.TASK_ID;
                break;
            }
            case "state": {
                sortAttribute = CQEngineUserTaskInfo.TASK_STATE;
                break;
            }
            case "priority": {
                sortAttribute = CQEngineUserTaskInfo.TASK_PRIORITY;
                break;
            }
            case "startDate": {
                sortAttribute = CQEngineUserTaskInfo.TASK_START_DATE;
                break;
            }
            default: {
                sortAttribute = CQEngineUserTaskInfo.TASK_START_DATE;
            }
        }
        return sortAttribute;
    }
}

