/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addons.usertasks.index.fs;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.hash.HashIndex;
import com.googlecode.cqengine.index.suffix.SuffixTreeIndex;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.disk.DiskPersistence;
import io.automatiko.addons.usertasks.index.fs.CQEngineUserTaskInfo;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class CQEngineBasedIndex {
    private IndexedCollection<CQEngineUserTaskInfo> tasks;
    private String path;

    public CQEngineBasedIndex(@ConfigProperty(name="quarkus.automatiko.index.usertasks.fs.path") Optional<String> path) {
        this.path = path.orElse(System.getProperty("java.io.tmpdir")) + File.separator + "automatiko-user-tasks.dat";
        try {
            Files.createDirectories(Paths.get(this.path, new String[0]).getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.tasks = new ConcurrentIndexedCollection((Persistence)DiskPersistence.onPrimaryKeyInFile(CQEngineUserTaskInfo.TASK_ID, (File)new File(this.path)));
    }

    @PostConstruct
    public void setup() {
        this.tasks.addIndex((Index)SuffixTreeIndex.onAttribute(CQEngineUserTaskInfo.TASK_NAME));
        this.tasks.addIndex((Index)SuffixTreeIndex.onAttribute(CQEngineUserTaskInfo.TASK_DESCRIPTION));
        this.tasks.addIndex((Index)HashIndex.onAttribute(CQEngineUserTaskInfo.POT_OWNERS));
        this.tasks.addIndex((Index)HashIndex.onAttribute(CQEngineUserTaskInfo.POT_GROUPS));
        this.tasks.addIndex((Index)HashIndex.onAttribute(CQEngineUserTaskInfo.EXCLUDED_USERS));
    }

    public IndexedCollection<CQEngineUserTaskInfo> get() {
        return this.tasks;
    }
}

