/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.process.management.export;

import io.automatiko.engine.addons.process.management.model.JsonExportedProcessInstance;
import io.automatiko.engine.api.workflow.ExportedProcessInstance;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.workflow.StringExportedProcessInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ProcessInstanceExporter {
    private final Map<String, Process<?>> processData;

    public ProcessInstanceExporter(Map<String, Process<?>> processData) {
        this.processData = processData;
    }

    public JsonExportedProcessInstance exportInstance(String id, ProcessInstance<?> processInstance) {
        Collection subInstances = processInstance.subprocesses();
        ArrayList<JsonExportedProcessInstance> subinstances = new ArrayList<JsonExportedProcessInstance>();
        if (!subInstances.isEmpty()) {
            for (ProcessInstance si : subInstances) {
                JsonExportedProcessInstance subExported = this.exportInstance(id + ":" + si.id(), si);
                subinstances.add(subExported);
            }
        }
        ExportedProcessInstance exported = processInstance.process().exportInstance(id, false);
        JsonExportedProcessInstance jsonExported = JsonExportedProcessInstance.of((ExportedProcessInstance<String>)exported);
        jsonExported.setSubInstances(subinstances);
        return jsonExported;
    }

    public ProcessInstance<?> importInstance(JsonExportedProcessInstance instance) {
        Process<?> process;
        String processVersion;
        if (!instance.getSubInstances().isEmpty()) {
            for (JsonExportedProcessInstance subinstance : instance.getSubInstances()) {
                this.importInstance(subinstance);
            }
        }
        Object processId = instance.getInstance().get("processId").asText();
        String string = processVersion = instance.getInstance().has("processVersion") ? instance.getInstance().get("processVersion").asText() : null;
        if (processVersion != null) {
            processId = (String)processId + "_" + processVersion.replaceAll("\\.", "_");
        }
        if ((process = this.processData.get(processId)) == null) {
            throw new IllegalStateException("No process found with '" + (String)processId + "' identifier");
        }
        return process.importInstance((ExportedProcessInstance)StringExportedProcessInstance.of((String)instance.getHeader().toString(), (String)instance.getInstance().toString(), (String)instance.getTimers().toString(), s -> instance.convertTimers()));
    }
}

