/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.process.management;

import io.automatiko.engine.addons.process.management.BaseProcessInstanceManagementResource;
import io.automatiko.engine.addons.process.management.export.ProcessInstanceExporter;
import io.automatiko.engine.addons.process.management.model.ErrorInfoDTO;
import io.automatiko.engine.addons.process.management.model.JsonExportedProcessInstance;
import io.automatiko.engine.addons.process.management.model.ProcessDTO;
import io.automatiko.engine.addons.process.management.model.ProcessInstanceDTO;
import io.automatiko.engine.addons.process.management.model.ProcessInstanceDetailsDTO;
import io.automatiko.engine.api.Application;
import io.automatiko.engine.api.Model;
import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.auth.IdentitySupplier;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import io.automatiko.engine.api.workflow.ArchiveBuilder;
import io.automatiko.engine.api.workflow.ArchivedProcessInstance;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessErrors;
import io.automatiko.engine.api.workflow.ProcessImageNotFoundException;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.ProcessInstanceNotFoundException;
import io.automatiko.engine.api.workflow.ProcessInstanceReadMode;
import io.automatiko.engine.api.workflow.VariableNotFoundException;
import io.automatiko.engine.services.uow.UnitOfWorkExecutor;
import io.automatiko.engine.services.utils.IoUtils;
import io.automatiko.engine.workflow.AbstractProcess;
import io.automatiko.engine.workflow.AbstractProcessInstance;
import io.automatiko.engine.workflow.base.core.ContextContainer;
import io.automatiko.engine.workflow.base.core.context.variable.VariableScope;
import io.automatiko.engine.workflow.json.JsonArchiveBuilder;
import io.automatiko.engine.workflow.process.core.WorkflowProcess;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.openapi.annotations.ExternalDocumentation;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(name="Process Management", description="Process management operations on top of the service", externalDocs=@ExternalDocumentation(description="Manangement UI", url="/management/processes/ui"))
@Path(value="/management/processes")
public class ProcessInstanceManagementResource
extends BaseProcessInstanceManagementResource<Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceManagementResource.class);
    private IdentitySupplier identitySupplier;
    private ProcessInstanceExporter exporter;
    private String serviceUrl;

    public ProcessInstanceManagementResource() {
        this(null, null, null, Optional.empty());
    }

    public ProcessInstanceManagementResource(Map<String, Process<?>> process, Application application, IdentitySupplier identitySupplier, @ConfigProperty(name="quarkus.automatiko.service-url") Optional<String> serviceUrl) {
        super(process, application);
        this.identitySupplier = identitySupplier;
        this.exporter = new ProcessInstanceExporter(this.processData);
        this.serviceUrl = serviceUrl.orElse(null);
    }

    @Inject
    public ProcessInstanceManagementResource(Application application, Instance<Process<?>> availableProcesses, IdentitySupplier identitySupplier) {
        super(availableProcesses == null ? Collections.emptyMap() : availableProcesses.stream().collect(Collectors.toMap(p -> p.id(), p -> p)), application);
        this.identitySupplier = identitySupplier;
        this.exporter = new ProcessInstanceExporter(this.processData);
    }

    @Override
    protected <R> Response buildOkResponse(R body) {
        return Response.status((Response.Status)Response.Status.OK).entity(body).build();
    }

    @Override
    protected Response badRequestResponse(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
    }

    @Override
    protected Response notFoundResponse(String message) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)message).build();
    }

    @APIResponses(value={@APIResponse(responseCode="200", content={@Content(mediaType="text/html")})})
    @Operation(summary="Entry point for the Process management UI", hidden=true)
    @GET
    @Path(value="/ui")
    @Produces(value={"text/html"})
    public String ui() throws IOException {
        return new String(IoUtils.readBytesFromInputStream((InputStream)this.getClass().getResourceAsStream("/automatiko-index.html")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Lists available public processes in the service")
    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public List<ProcessDTO> get(@Parameter(description="Pagination - page to start on", required=false) @QueryParam(value="page") @DefaultValue(value="1") int page, @Parameter(description="Pagination - number of items to return", required=false) @QueryParam(value="size") @DefaultValue(value="10") int size, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        ArrayList<ProcessDTO> collected = new ArrayList<ProcessDTO>();
        try {
            this.identitySupplier.buildIdentityProvider(user, groups);
            for (String id : this.processData.keySet()) {
                Process process = (Process)this.processData.get(id);
                if (!"Public".equals(((WorkflowProcess)((AbstractProcess)process).process()).getVisibility())) continue;
                Object pathprefix = "";
                if (process.version() != null) {
                    pathprefix = "v" + process.version().replaceAll("\\.", "_") + "/";
                }
                collected.add(new ProcessDTO(id, process.version(), process.name(), process.description(), (this.serviceUrl == null ? "" : this.serviceUrl) + "/" + (String)pathprefix + ((AbstractProcess)process).process().getId() + "/image", process.instances().size()));
            }
            ArrayList<ProcessDTO> arrayList = collected;
            return arrayList;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="200", description="List of available process instances of the given process", content={@Content(mediaType="application/json")})})
    @Operation(summary="Lists available process instances of given process")
    @GET
    @Path(value="/{processId}/instances")
    @Produces(value={"application/json"})
    public List<ProcessInstanceDTO> getInstances(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Status of the process instance", required=false, schema=@Schema(enumeration={"active", "completed", "aborted", "error"})) @QueryParam(value="status") @DefaultValue(value="active") String status, @Parameter(description="Pagination - page to start on", required=false) @QueryParam(value="page") @DefaultValue(value="1") int page, @Parameter(description="Pagination - number of items to return", required=false) @QueryParam(value="size") @DefaultValue(value="10") int size, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        ArrayList collected = new ArrayList();
        try {
            this.identitySupplier.buildIdentityProvider(user, groups);
            Process process = (Process)this.processData.get(processId);
            List list = (List)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                process.instances().values(ProcessInstanceReadMode.READ_ONLY, this.mapStatus(status), page, size).forEach(pi -> collected.add(new ProcessInstanceDTO(pi.id(), pi.parentProcessInstanceId(), pi.businessKey() == null ? "" : pi.businessKey(), pi.description(), pi.tags().values(), pi.errors().isPresent(), processId, pi.status())));
                return collected;
            });
            return list;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Process instance details", content={@Content(mediaType="application/json")})})
    @Operation(summary="Returns process instance details for given instance id")
    @GET
    @Path(value="/{processId}/instances/{instanceId}")
    @Produces(value={"application/json"})
    public ProcessInstanceDetailsDTO getInstance(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="instanceId") String instanceId, @Parameter(description="Status of the process instance", required=false, schema=@Schema(enumeration={"active", "completed", "aborted", "error"})) @QueryParam(value="status") @DefaultValue(value="active") String status, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        try {
            this.identitySupplier.buildIdentityProvider(user, groups);
            ProcessInstanceDetailsDTO processInstanceDetailsDTO = (ProcessInstanceDetailsDTO)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                Process process = (Process)this.processData.get(processId);
                Optional instance = process.instances().findById(instanceId, this.mapStatus(status), ProcessInstanceReadMode.READ_ONLY);
                if (instance.isEmpty()) {
                    throw new ProcessInstanceNotFoundException(instanceId);
                }
                ProcessInstance pi = (ProcessInstance)instance.get();
                ProcessInstanceDetailsDTO details = new ProcessInstanceDetailsDTO();
                Object id = pi.id();
                if (pi.parentProcessInstanceId() != null) {
                    id = pi.parentProcessInstanceId() + ":" + (String)id;
                }
                details.setId((String)id);
                details.setProcessId(processId);
                details.setBusinessKey(pi.businessKey() == null ? "" : pi.businessKey());
                details.setDescription(pi.description());
                details.setState(pi.status());
                details.setFailed(pi.errors().isPresent());
                if (pi.errors().isPresent()) {
                    details.setErrors(((ProcessErrors)pi.errors().get()).errors().stream().map(e -> new ErrorInfoDTO(e.failedNodeId(), e.errorId(), e.errorMessage(), e.errorDetails())).collect(Collectors.toList()));
                }
                details.setImage((this.serviceUrl == null ? "" : this.serviceUrl) + "/management/processes/" + processId + "/instances/" + instanceId + "/image?status=" + this.reverseMapStatus(pi.status()));
                details.setTags(pi.tags().values());
                details.setVariables(pi.variables());
                details.setSubprocesses(pi.subprocesses().stream().map(spi -> new ProcessInstanceDTO(spi.id(), spi.parentProcessInstanceId(), spi.businessKey(), spi.description(), spi.tags().values(), spi.errors().isPresent(), spi.process().id(), spi.status())).collect(Collectors.toList()));
                VariableScope variableScope = (VariableScope)((ContextContainer)((AbstractProcess)process).process()).getDefaultContext("VariableScope");
                details.setVersionedVariables(variableScope.getVariables().stream().filter(v -> v.hasTag("versioned")).map(v -> v.getName()).collect(Collectors.toList()));
                return details;
            });
            return processInstanceDetailsDTO;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found or variable was not versioned", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Variable versions currently known to the process instance", content={@Content(mediaType="application/json")})})
    @Operation(summary="Returns list of versions of a given variable that is marked as versioned")
    @GET
    @Path(value="/{processId}/instances/{instanceId}/variables/{name}/versions")
    @Produces(value={"application/json"})
    public List<Object> getInstanceVariableVersions(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="instanceId") String instanceId, @Parameter(description="Status of the process instance", required=false, schema=@Schema(enumeration={"active", "completed", "aborted", "error"})) @QueryParam(value="status") @DefaultValue(value="active") String status, @Parameter(description="Unique name of the process variable", required=true) @PathParam(value="name") String name, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        try {
            this.identitySupplier.buildIdentityProvider(user, groups);
            List list = (List)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                Process process = (Process)this.processData.get(processId);
                Optional instance = process.instances().findById(instanceId, this.mapStatus(status), ProcessInstanceReadMode.READ_ONLY);
                if (instance.isEmpty()) {
                    throw new ProcessInstanceNotFoundException(instanceId);
                }
                ProcessInstance pi = (ProcessInstance)instance.get();
                Map versions = (Map)((AbstractProcessInstance)pi).processInstance().getVariable("__versioned__");
                List varVersions = (List)versions.get(name);
                if (varVersions == null) {
                    throw new VariableNotFoundException(instanceId, name);
                }
                return varVersions;
            });
            return list;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found or variable was not versioned", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Variable versions currently known to the process instance", content={@Content(mediaType="application/json")})})
    @Operation(summary="Returns list of versions of a given variable that is marked as versioned")
    @POST
    @Path(value="/{processId}/instances/{instanceId}/variables/{name}/versions/{version}")
    @Produces(value={"application/json"})
    public List<Object> restoreInstanceVariableVersions(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="instanceId") String instanceId, @Parameter(description="Status of the process instance", required=false, schema=@Schema(enumeration={"active", "completed", "aborted", "error"})) @QueryParam(value="status") @DefaultValue(value="active") String status, @Parameter(description="Unique name of the process variable", required=true) @PathParam(value="name") String name, @Parameter(description="Version number of the process variable to be made as current", required=true) @PathParam(value="version") Integer version, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (List)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Process process = (Process)this.processData.get(processId);
            Optional instance = process.instances().findById(instanceId, this.mapStatus(status), ProcessInstanceReadMode.MUTABLE_WITH_LOCK);
            if (instance.isEmpty()) {
                throw new ProcessInstanceNotFoundException(instanceId);
            }
            ProcessInstance pi = (ProcessInstance)instance.get();
            Map versions = (Map)((AbstractProcessInstance)pi).processInstance().getVariable("__versioned__");
            List varVersions = (List)versions.get(name);
            if (varVersions == null || version < 0 || varVersions.size() <= version) {
                throw new VariableNotFoundException(instanceId, name);
            }
            ((AbstractProcessInstance)pi).processInstance().setVariable(name, varVersions.get(version));
            ((AbstractProcessInstance)pi).updateVariables((Model)process.createModel());
            versions = (Map)((AbstractProcessInstance)pi).processInstance().getVariable("__versioned__");
            varVersions = (List)versions.get(name);
            return varVersions;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Returns process instance image with annotated active nodes")
    @GET
    @Path(value="/{processId}/instances/{instanceId}/image")
    @Produces(value={"application/svg+xml"})
    public Response getInstanceImage(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="instanceId") String instanceId, @Parameter(description="Status of the process instance", required=false, schema=@Schema(enumeration={"active", "completed", "aborted", "error"})) @QueryParam(value="status") @DefaultValue(value="active") String status, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        try {
            this.identitySupplier.buildIdentityProvider(user, groups);
            Response response = (Response)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                Process process = (Process)this.processData.get(processId);
                String image = process.image();
                if (image == null) {
                    throw new ProcessImageNotFoundException(process.id());
                }
                Optional instance = process.instances().findById(instanceId, this.mapStatus(status), ProcessInstanceReadMode.READ_ONLY);
                if (instance.isEmpty()) {
                    throw new ProcessInstanceNotFoundException(instanceId);
                }
                String path = ((AbstractProcess)process).process().getId() + "/" + instanceId;
                if (process.version() != null) {
                    path = "/v" + process.version().replaceAll("\\.", "_") + "/" + path;
                }
                Response.ResponseBuilder builder = Response.ok().entity((Object)((ProcessInstance)instance.get()).image(path));
                return builder.header("Content-Type", (Object)"image/svg+xml").build();
            });
            return response;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    @Override
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Returns error information for given process instance if the instance is in error")
    @GET
    @Path(value="/{processId}/instances/{processInstanceId}/error")
    @Produces(value={"application/json"})
    public Response getInstanceInError(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="processInstanceId") String processInstanceId, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (Response)this.doGetInstanceInError(processId, processInstanceId);
    }

    @Override
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Retruns node instances currently active in given process instance")
    @GET
    @Path(value="/{processId}/instances/{processInstanceId}/nodeInstances")
    @Produces(value={"application/json"})
    public Response getWorkItemsInProcessInstance(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="processInstanceId") String processInstanceId, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (Response)this.doGetWorkItemsInProcessInstance(processId, processInstanceId);
    }

    @Override
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Retriggers the node instance that is in error")
    @POST
    @Path(value="/{processId}/instances/{processInstanceId}/retrigger")
    @Produces(value={"application/json"})
    public Response retriggerInstanceInError(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="processInstanceId") String processInstanceId, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (Response)this.doRetriggerInstanceInError(processId, processInstanceId);
    }

    @Override
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Retriggers the node instance that is in error")
    @POST
    @Path(value="/{processId}/instances/{processInstanceId}/retrigger/{errorId}")
    @Produces(value={"application/json"})
    public Response retriggerInstanceInErrorByErrorId(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="processInstanceId") String processInstanceId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="errorId") String errorId, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (Response)this.doRetriggerInstanceInErrorByErrorId(processId, processInstanceId, errorId);
    }

    @Override
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Skips the node instance that is in error")
    @POST
    @Path(value="/{processId}/instances/{processInstanceId}/skip")
    @Produces(value={"application/json"})
    public Response skipInstanceInError(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="processInstanceId") String processInstanceId, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (Response)this.doSkipInstanceInError(processId, processInstanceId);
    }

    @Override
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Skips the node instance that is in error")
    @POST
    @Path(value="/{processId}/instances/{processInstanceId}/skip/{errorId}")
    @Produces(value={"application/json"})
    public Response skipInstanceInErrorByErrorId(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="processInstanceId") String processInstanceId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="errorId") String errorId, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (Response)this.doSkipInstanceInErrorByErrorId(processId, processInstanceId, errorId);
    }

    @Override
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Trigger new node instance of a given node in process instance")
    @POST
    @Path(value="/{processId}/instances/{processInstanceId}/nodes/{nodeId}")
    @Produces(value={"application/json"})
    public Response triggerNodeInstanceId(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="processInstanceId") String processInstanceId, @Parameter(description="Unique identifier of the node to be triggered", required=true) @PathParam(value="nodeId") String nodeId, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (Response)this.doTriggerNodeInstanceId(processId, processInstanceId, nodeId);
    }

    @Override
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Retriggers (preior to triggering it cancels current instance) node instance in given process instance")
    @POST
    @Path(value="/{processId}/instances/{processInstanceId}/nodeInstances/{nodeInstanceId}")
    @Produces(value={"application/json"})
    public Response retriggerNodeInstanceId(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="processInstanceId") String processInstanceId, @Parameter(description="Unique identifier of the node instance", required=true) @PathParam(value="nodeInstanceId") String nodeInstanceId, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (Response)this.doRetriggerNodeInstanceId(processId, processInstanceId, nodeInstanceId);
    }

    @Override
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Cancels given node instance in the process instance")
    @DELETE
    @Path(value="/{processId}/instances/{processInstanceId}/nodeInstances/{nodeInstanceId}")
    @Produces(value={"application/json"})
    public Response cancelNodeInstanceId(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="processInstanceId") String processInstanceId, @Parameter(description="Unique identifier of the node instance", required=true) @PathParam(value="nodeInstanceId") String nodeInstanceId, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (Response)this.doCancelNodeInstanceId(processId, processInstanceId, nodeInstanceId);
    }

    @Override
    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="List of available processes", content={@Content(mediaType="application/json")})})
    @Operation(summary="Aborts given process instance")
    @DELETE
    @Path(value="/{processId}/instances/{processInstanceId}")
    @Produces(value={"application/json"})
    public Response cancelProcessInstanceId(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="processInstanceId") String processInstanceId, @Parameter(description="Status of the process instance", required=false, schema=@Schema(enumeration={"active", "completed", "aborted", "error"})) @QueryParam(value="status") @DefaultValue(value="active") String status, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (Response)this.doCancelProcessInstanceId(processId, processInstanceId, status);
    }

    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))}), @APIResponse(responseCode="200", description="Exported process instance", content={@Content(mediaType="application/json")})})
    @Operation(summary="Returns exported process instance for given instance id")
    @GET
    @Path(value="/{processId}/instances/{instanceId}/export")
    @Produces(value={"application/json"})
    public JsonExportedProcessInstance exportInstance(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="instanceId") String instanceId, @Parameter(description="Status of the process instance", required=false) @QueryParam(value="status") @DefaultValue(value="active") String status, @Parameter(description="Indicates if the instance should be aborted after export, defaults to false", required=false) @QueryParam(value="abort") @DefaultValue(value="false") boolean abort, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        JsonExportedProcessInstance exported = (JsonExportedProcessInstance)((Object)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Process process = (Process)this.processData.get(processId);
            if (process == null) {
                throw new ProcessInstanceNotFoundException(instanceId);
            }
            Optional instance = process.instances().findById(instanceId, this.mapStatus(status), ProcessInstanceReadMode.MUTABLE);
            if (instance.isEmpty()) {
                throw new ProcessInstanceNotFoundException(instanceId);
            }
            ProcessInstance pi = (ProcessInstance)instance.get();
            return this.exporter.exportInstance(instanceId, pi);
        }));
        if (abort) {
            this.cancelProcessInstanceId(processId, instanceId, status, user, groups);
        }
        return exported;
    }

    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given process id was not found", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="200", description="Exported process instance", content={@Content(mediaType="application/json")})})
    @Operation(summary="Imports exported process instance and returns its details after the import")
    @POST
    @Path(value="/{processId}/instances")
    @Produces(value={"application/json"})
    public ProcessInstanceDetailsDTO importInstance(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups, @Parameter(description="The input model for orders instance", schema=@Schema(type=SchemaType.OBJECT, implementation=Map.class)) JsonExportedProcessInstance instance) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        return (ProcessInstanceDetailsDTO)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance<?> pi = this.exporter.importInstance(instance);
            ProcessInstanceDetailsDTO details = new ProcessInstanceDetailsDTO();
            details.setId(pi.id());
            details.setProcessId(processId);
            details.setBusinessKey(pi.businessKey());
            details.setDescription(pi.description());
            details.setFailed(pi.errors().isPresent());
            if (pi.errors().isPresent()) {
                details.setErrors(((ProcessErrors)pi.errors().get()).errors().stream().map(e -> new ErrorInfoDTO(e.failedNodeId(), e.errorId(), e.errorMessage(), e.errorDetails())).collect(Collectors.toList()));
            }
            details.setImage((this.serviceUrl == null ? "" : this.serviceUrl) + "/management/processes/" + processId + "/instances/" + pi.id() + "/image");
            details.setTags(pi.tags().values());
            details.setVariables(pi.variables());
            VariableScope variableScope = (VariableScope)((ContextContainer)((AbstractProcess)pi.process()).process()).getDefaultContext("VariableScope");
            details.setVersionedVariables(variableScope.getVariables().stream().filter(v -> v.hasTag("versioned")).map(v -> v.getName()).collect(Collectors.toList()));
            return details;
        });
    }

    @APIResponses(value={@APIResponse(responseCode="404", description="In case of instance with given id was not found", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))}), @APIResponse(responseCode="200", description="Exported process instance", content={@Content(mediaType="application/json")})})
    @Operation(summary="Returns archived process instance for given instance id as zip")
    @GET
    @Path(value="/{processId}/instances/{instanceId}/archive")
    @Produces(value={"application/zip"})
    public Response archiveInstance(@Parameter(description="Unique identifier of the process", required=true) @PathParam(value="processId") String processId, @Parameter(description="Unique identifier of the instance", required=true) @PathParam(value="instanceId") String instanceId, @Parameter(description="Indicates if the instance should be aborted after export, defaults to false", required=false) @QueryParam(value="abort") @DefaultValue(value="false") boolean abort, @Parameter(description="User identifier as alternative autroization info", required=false, hidden=true) @QueryParam(value="user") String user, @Parameter(description="Groups as alternative autroization info", required=false, hidden=true) @QueryParam(value="group") List<String> groups) {
        this.identitySupplier.buildIdentityProvider(user, groups);
        try {
            AtomicReference archiveId = new AtomicReference();
            ByteArrayOutputStream output = (ByteArrayOutputStream)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                Process process = (Process)this.processData.get(processId);
                if (process == null) {
                    throw new ProcessInstanceNotFoundException(instanceId);
                }
                Optional instance = process.instances().findById(instanceId);
                if (instance.isEmpty()) {
                    throw new ProcessInstanceNotFoundException(instanceId);
                }
                ProcessInstance pi = (ProcessInstance)instance.get();
                ArchivedProcessInstance archived = pi.archive((ArchiveBuilder)new JsonArchiveBuilder());
                archiveId.set(archived.getId());
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                try {
                    archived.writeAsZip((OutputStream)data);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (abort) {
                    this.cancelProcessInstanceId(processId, instanceId, "active", user, groups);
                }
                return data;
            });
            Response.ResponseBuilder builder = Response.ok().entity((Object)output.toByteArray());
            return builder.header("Content-Type", (Object)"application/zip").header("Content-Disposition", (Object)("attachment; filename=" + archiveId + ".zip")).build();
        }
        catch (Exception e) {
            LOGGER.error("Error generating process instance archive", (Throwable)e);
            return Response.serverError().entity((Object)"Error generating process instance archive").build();
        }
    }
}

