/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.Member;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftMemberContext;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.ActiveRole;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.utils.Quorum;
import io.atomix.storage.journal.Indexed;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.event.EventListener;
import java.time.Duration;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class FollowerRole
extends ActiveRole {
    private final ClusterMembershipEventListener clusterListener = this::handleClusterEvent;
    private final Random random = new Random();
    private Scheduled heartbeatTimer;

    public FollowerRole(RaftContext context) {
        super(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.FOLLOWER;
    }

    @Override
    public synchronized CompletableFuture<RaftRole> start() {
        this.raft.getMembershipService().addListener((EventListener)this.clusterListener);
        return ((CompletableFuture)super.start().thenRun(this::resetHeartbeatTimeout)).thenApply(v -> this);
    }

    private void handleClusterEvent(ClusterMembershipEvent event) {
        DefaultRaftMember leader = this.raft.getLeader();
        if (leader != null && event.type() == ClusterMembershipEvent.Type.MEMBER_REMOVED && ((Member)event.subject()).id().equals((Object)leader.memberId())) {
            this.sendPollRequests();
        }
    }

    private void resetHeartbeatTimeout() {
        this.raft.checkThread();
        if (!this.isRunning()) {
            return;
        }
        if (this.heartbeatTimer != null) {
            this.heartbeatTimer.cancel();
        }
        Duration delay = this.raft.getElectionTimeout().plus(Duration.ofMillis(this.random.nextInt((int)this.raft.getElectionTimeout().toMillis())));
        this.heartbeatTimer = this.raft.getThreadContext().schedule(delay, () -> {
            this.heartbeatTimer = null;
            if (this.isRunning() && (this.raft.getFirstCommitIndex() == 0L || this.raft.getState() == RaftContext.State.READY)) {
                this.raft.setLeader(null);
                this.log.debug("Heartbeat timed out in {}", (Object)delay);
                this.sendPollRequests();
            }
        });
    }

    private void sendPollRequests() {
        this.heartbeatTimer = this.raft.getThreadContext().schedule(this.raft.getElectionTimeout(), () -> {
            this.log.debug("Failed to poll a majority of the cluster in {}", (Object)this.raft.getElectionTimeout());
            this.resetHeartbeatTimeout();
        });
        AtomicBoolean complete = new AtomicBoolean();
        Set votingMembers = this.raft.getCluster().getActiveMemberStates().stream().map(RaftMemberContext::getMember).collect(Collectors.toSet());
        if (votingMembers.isEmpty()) {
            this.raft.transition(RaftServer.Role.CANDIDATE);
            return;
        }
        Quorum quorum = new Quorum(this.raft.getCluster().getQuorum(), elected -> {
            complete.set(true);
            if (elected.booleanValue()) {
                this.raft.transition(RaftServer.Role.CANDIDATE);
            } else {
                this.resetHeartbeatTimeout();
            }
        });
        Indexed lastEntry = this.raft.getLogWriter().getLastEntry();
        long lastTerm = lastEntry != null ? ((RaftLogEntry)lastEntry.entry()).term() : 0L;
        this.log.debug("Polling members {}", votingMembers);
        for (DefaultRaftMember member : votingMembers) {
            this.log.debug("Polling {} for next term {}", (Object)member, (Object)(this.raft.getTerm() + 1L));
            PollRequest request = PollRequest.builder().withTerm(this.raft.getTerm()).withCandidate(this.raft.getCluster().getMember().memberId()).withLastLogIndex(lastEntry != null ? lastEntry.index() : 0L).withLastLogTerm(lastTerm).build();
            this.raft.getProtocol().poll(member.memberId(), request).whenCompleteAsync((response, error) -> {
                this.raft.checkThread();
                if (this.isRunning() && !complete.get()) {
                    if (error != null) {
                        this.log.warn("{}", (Object)error.getMessage());
                        quorum.fail();
                    } else {
                        if (response.term() > this.raft.getTerm()) {
                            this.raft.setTerm(response.term());
                        }
                        if (!response.accepted()) {
                            this.log.debug("Received rejected poll from {}", (Object)member);
                            quorum.fail();
                        } else if (response.term() != this.raft.getTerm()) {
                            this.log.debug("Received accepted poll for a different term from {}", (Object)member);
                            quorum.fail();
                        } else {
                            this.log.debug("Received accepted poll from {}", (Object)member);
                            quorum.succeed();
                        }
                    }
                }
            }, (Executor)this.raft.getThreadContext());
        }
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        CompletableFuture<InstallResponse> future = super.onInstall(request);
        this.resetHeartbeatTimeout();
        return future;
    }

    @Override
    public CompletableFuture<ConfigureResponse> onConfigure(ConfigureRequest request) {
        CompletableFuture<ConfigureResponse> future = super.onConfigure(request);
        this.resetHeartbeatTimeout();
        return future;
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        CompletableFuture<AppendResponse> future = super.onAppend(request);
        this.resetHeartbeatTimeout();
        return future;
    }

    @Override
    protected VoteResponse handleVote(VoteRequest request) {
        VoteResponse response = super.handleVote(request);
        if (response.voted()) {
            this.resetHeartbeatTimeout();
        }
        return response;
    }

    private void cancelHeartbeatTimers() {
        if (this.heartbeatTimer != null) {
            this.log.trace("Cancelling heartbeat timer");
            this.heartbeatTimer.cancel();
        }
    }

    @Override
    public synchronized CompletableFuture<Void> stop() {
        this.raft.getMembershipService().removeListener((EventListener)this.clusterListener);
        return super.stop().thenRun(this::cancelHeartbeatTimers);
    }
}

