/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import com.google.common.base.Preconditions;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionService;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.proxy.impl.DefaultProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.session.SessionClient;
import io.atomix.protocols.raft.MultiRaftProtocolBuilder;
import io.atomix.protocols.raft.MultiRaftProtocolConfig;
import io.atomix.protocols.raft.partition.RaftPartition;
import java.util.Collection;
import java.util.stream.Collectors;

public class MultiRaftProtocol
implements ProxyProtocol {
    public static final Type TYPE = new Type();
    private final MultiRaftProtocolConfig config;

    public static MultiRaftProtocol instance() {
        return new MultiRaftProtocol(new MultiRaftProtocolConfig());
    }

    public static MultiRaftProtocolBuilder builder() {
        return new MultiRaftProtocolBuilder(new MultiRaftProtocolConfig());
    }

    public static MultiRaftProtocolBuilder builder(String group) {
        return new MultiRaftProtocolBuilder(new MultiRaftProtocolConfig().setGroup(group));
    }

    protected MultiRaftProtocol(MultiRaftProtocolConfig config) {
        this.config = (MultiRaftProtocolConfig)((Object)Preconditions.checkNotNull((Object)((Object)config), (Object)"config cannot be null"));
    }

    public PrimitiveProtocol.Type type() {
        return TYPE;
    }

    public String group() {
        return this.config.getGroup();
    }

    public <S> ProxyClient<S> newProxy(String primitiveName, PrimitiveType primitiveType, Class<S> serviceType, ServiceConfig serviceConfig, PartitionService partitionService) {
        Collection partitions = partitionService.getPartitionGroup((ProxyProtocol)this).getPartitions().stream().map(partition -> (SessionClient)((RaftPartition)partition).getClient().sessionBuilder(primitiveName, primitiveType, serviceConfig).withMinTimeout(this.config.getMinTimeout()).withMaxTimeout(this.config.getMaxTimeout()).withReadConsistency(this.config.getReadConsistency()).withCommunicationStrategy(this.config.getCommunicationStrategy()).withRecoveryStrategy(this.config.getRecoveryStrategy()).withMaxRetries(this.config.getMaxRetries()).withRetryDelay(this.config.getRetryDelay()).build()).collect(Collectors.toList());
        return new DefaultProxyClient(primitiveName, primitiveType, (PrimitiveProtocol)this, serviceType, partitions, this.config.getPartitioner());
    }

    public static final class Type
    implements PrimitiveProtocol.Type<MultiRaftProtocolConfig> {
        private static final String NAME = "multi-raft";

        public String name() {
            return NAME;
        }

        public MultiRaftProtocolConfig newConfig() {
            return new MultiRaftProtocolConfig();
        }

        public PrimitiveProtocol newProtocol(MultiRaftProtocolConfig config) {
            return new MultiRaftProtocol(config);
        }
    }
}

