/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.compaction;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Segment;
import io.atomix.copycat.server.storage.SegmentManager;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.compaction.CompactionManager;
import io.atomix.copycat.server.storage.compaction.CompactionTask;
import io.atomix.copycat.server.storage.compaction.Compactor;
import io.atomix.copycat.server.storage.compaction.MinorCompactionTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class MinorCompactionManager
implements CompactionManager {
    private final Compactor compactor;

    MinorCompactionManager(Compactor compactor) {
        this.compactor = Assert.notNull(compactor, "compactor");
    }

    public List<CompactionTask> buildTasks(Storage storage, SegmentManager segments) {
        ArrayList<CompactionTask> tasks = new ArrayList<CompactionTask>(segments.segments().size());
        for (Segment segment : this.getCompactableSegments(storage, segments)) {
            tasks.add(new MinorCompactionTask(segments, segment, this.compactor.snapshotIndex(), this.compactor.majorIndex(), this.compactor.getDefaultCompactionMode()));
        }
        return tasks;
    }

    private Iterable<Segment> getCompactableSegments(Storage storage, SegmentManager manager) {
        ArrayList<Segment> segments = new ArrayList<Segment>(manager.segments().size());
        Iterator<Segment> iterator = manager.segments().iterator();
        Segment segment = iterator.next();
        while (iterator.hasNext()) {
            double compactablePercentage;
            Segment nextSegment = iterator.next();
            if ((segment.isCompacted() || segment.isFull() && segment.lastIndex() < this.compactor.minorIndex() && nextSegment.firstIndex() <= manager.commitIndex() && !nextSegment.isEmpty()) && (compactablePercentage = (double)segment.releaseCount() / (double)segment.count()) * (double)segment.descriptor().version() >= storage.compactionThreshold()) {
                segments.add(segment);
            }
            segment = nextSegment;
        }
        return segments;
    }
}

