/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.compaction;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Segment;
import io.atomix.copycat.server.storage.SegmentDescriptor;
import io.atomix.copycat.server.storage.SegmentManager;
import io.atomix.copycat.server.storage.compaction.Compaction;
import io.atomix.copycat.server.storage.compaction.CompactionTask;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.util.OffsetPredicate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MajorCompactionTask
implements CompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MajorCompactionTask.class);
    private final SegmentManager manager;
    private final List<List<Segment>> groups;
    private List<List<OffsetPredicate>> predicates;
    private final long snapshotIndex;
    private final long compactIndex;
    private final Compaction.Mode defaultCompactionMode;

    MajorCompactionTask(SegmentManager manager, List<List<Segment>> groups, long snapshotIndex, long compactIndex, Compaction.Mode defaultCompactionMode) {
        this.manager = Assert.notNull(manager, "manager");
        this.groups = Assert.notNull(groups, "segments");
        this.snapshotIndex = snapshotIndex;
        this.compactIndex = compactIndex;
        this.defaultCompactionMode = Assert.notNull(defaultCompactionMode, "defaultCompactionMode");
    }

    @Override
    public void run() {
        this.copyPredicates();
        this.compactGroups();
    }

    private void copyPredicates() {
        this.predicates = new ArrayList<List<OffsetPredicate>>(this.groups.size());
        for (List<Segment> group : this.groups) {
            ArrayList<OffsetPredicate> groupPredicates = new ArrayList<OffsetPredicate>(group.size());
            for (Segment segment : group) {
                groupPredicates.add(segment.offsetPredicate().copy());
            }
            this.predicates.add(groupPredicates);
        }
    }

    private void compactGroups() {
        for (int i = 0; i < this.groups.size(); ++i) {
            List<Segment> group = this.groups.get(i);
            List<OffsetPredicate> groupPredicates = this.predicates.get(i);
            Segment segment = this.compactGroup(group, groupPredicates);
            this.mergeReleased(group, groupPredicates, segment);
            this.deleteGroup(group);
        }
    }

    private Segment compactGroup(List<Segment> segments, List<OffsetPredicate> predicates) {
        Segment firstSegment = segments.iterator().next();
        Segment compactSegment = this.manager.createSegment(SegmentDescriptor.builder().withId(firstSegment.descriptor().id()).withVersion(firstSegment.descriptor().version() + 1L).withIndex(firstSegment.descriptor().index()).withMaxSegmentSize(Math.max(segments.stream().mapToLong(s -> s.descriptor().maxSegmentSize()).max().getAsLong(), (long)this.manager.storage().maxSegmentSize())).withMaxEntries(Math.max(segments.stream().mapToInt(s -> s.descriptor().maxEntries()).max().getAsInt(), this.manager.storage().maxEntriesPerSegment())).build());
        this.compactGroup(segments, predicates, compactSegment);
        this.manager.replaceSegments(segments, compactSegment);
        return compactSegment;
    }

    private void compactGroup(List<Segment> segments, List<OffsetPredicate> predicates, Segment compactSegment) {
        for (int i = 0; i < segments.size(); ++i) {
            this.compactSegment(segments.get(i), predicates.get(i), compactSegment);
        }
    }

    private void compactSegment(Segment segment, OffsetPredicate predicate, Segment compactSegment) {
        for (long i = segment.firstIndex(); i <= segment.lastIndex(); ++i) {
            this.checkEntry(i, segment, predicate, compactSegment);
        }
    }

    private void checkEntry(long index, Segment segment, OffsetPredicate predicate, Segment compactSegment) {
        try (Object entry = segment.get(index);){
            if (entry != null) {
                this.checkEntry(index, (Entry)entry, segment, predicate, compactSegment);
            } else {
                compactSegment.skip(1L);
            }
        }
    }

    private void checkEntry(long index, Entry entry, Segment segment, OffsetPredicate predicate, Segment compactSegment) {
        Compaction.Mode mode = entry.getCompactionMode();
        if (mode == Compaction.Mode.DEFAULT) {
            mode = this.defaultCompactionMode;
        }
        switch (mode) {
            case SNAPSHOT: {
                if (index <= this.snapshotIndex && !this.isLive(index, segment, predicate)) {
                    this.compactEntry(index, segment, compactSegment);
                    break;
                }
                this.transferEntry(entry, compactSegment);
                break;
            }
            case RELEASE: 
            case QUORUM: {
                if (!this.isLive(index, segment, predicate)) {
                    this.compactEntry(index, segment, compactSegment);
                    break;
                }
                this.transferEntry(entry, compactSegment);
                break;
            }
            case FULL: 
            case SEQUENTIAL: 
            case EXPIRING: 
            case TOMBSTONE: {
                if (index <= this.compactIndex && !this.isLive(index, segment, predicate)) {
                    this.compactEntry(index, segment, compactSegment);
                    break;
                }
                this.transferEntry(entry, compactSegment);
                break;
            }
            case UNKNOWN: {
                if (index <= this.snapshotIndex && index <= this.compactIndex && !this.isLive(index, segment, predicate)) {
                    this.compactEntry(index, segment, compactSegment);
                    break;
                }
                this.transferEntry(entry, compactSegment);
                break;
            }
        }
    }

    private void compactEntry(long index, Segment segment, Segment compactSegment) {
        compactSegment.skip(1L);
        LOGGER.trace("Compacted entry {} from segment {}", (Object)index, (Object)segment.descriptor().id());
    }

    private void transferEntry(Entry entry, Segment compactSegment) {
        compactSegment.append(entry);
    }

    private boolean isLive(long index, Segment segment, OffsetPredicate predicate) {
        long offset = segment.offset(index);
        return offset != -1L && predicate.test(offset);
    }

    private void mergeReleased(List<Segment> segments, List<OffsetPredicate> predicates, Segment compactSegment) {
        for (int i = 0; i < segments.size(); ++i) {
            this.mergeReleasedEntries(segments.get(i), predicates.get(i), compactSegment);
        }
    }

    private void mergeReleasedEntries(Segment segment, OffsetPredicate predicate, Segment compactSegment) {
        for (long i = segment.firstIndex(); i <= segment.lastIndex(); ++i) {
            long offset = segment.offset(i);
            if (offset == -1L || predicate.test(offset)) continue;
            compactSegment.release(i);
        }
    }

    private void deleteGroup(List<Segment> group) {
        for (Segment oldSegment : group) {
            oldSegment.close();
            oldSegment.delete();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

