/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.Listeners;
import io.atomix.catalyst.concurrent.SingleThreadContext;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.CommandRequest;
import io.atomix.copycat.protocol.ConnectRequest;
import io.atomix.copycat.protocol.KeepAliveRequest;
import io.atomix.copycat.protocol.QueryRequest;
import io.atomix.copycat.protocol.RegisterRequest;
import io.atomix.copycat.protocol.ResetRequest;
import io.atomix.copycat.protocol.UnregisterRequest;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachine;
import io.atomix.copycat.server.cluster.Cluster;
import io.atomix.copycat.server.cluster.Member;
import io.atomix.copycat.server.protocol.AppendRequest;
import io.atomix.copycat.server.protocol.ConfigureRequest;
import io.atomix.copycat.server.protocol.InstallRequest;
import io.atomix.copycat.server.protocol.JoinRequest;
import io.atomix.copycat.server.protocol.LeaveRequest;
import io.atomix.copycat.server.protocol.PollRequest;
import io.atomix.copycat.server.protocol.ReconfigureRequest;
import io.atomix.copycat.server.protocol.VoteRequest;
import io.atomix.copycat.server.state.AbstractState;
import io.atomix.copycat.server.state.ActiveState;
import io.atomix.copycat.server.state.CandidateState;
import io.atomix.copycat.server.state.ClusterState;
import io.atomix.copycat.server.state.ConnectionManager;
import io.atomix.copycat.server.state.FollowerState;
import io.atomix.copycat.server.state.InactiveState;
import io.atomix.copycat.server.state.LeaderState;
import io.atomix.copycat.server.state.PassiveState;
import io.atomix.copycat.server.state.ReserveState;
import io.atomix.copycat.server.state.ServerMember;
import io.atomix.copycat.server.state.ServerState;
import io.atomix.copycat.server.state.ServerStateMachine;
import io.atomix.copycat.server.storage.Log;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.compaction.Compaction;
import io.atomix.copycat.server.storage.snapshot.SnapshotStore;
import io.atomix.copycat.server.storage.system.MetaStore;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContext
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerContext.class);
    private final Listeners<CopycatServer.State> stateChangeListeners = new Listeners();
    private final Listeners<Member> electionListeners = new Listeners();
    protected final String name;
    protected final ThreadContext threadContext;
    protected final Supplier<StateMachine> stateMachineFactory;
    protected final ClusterState cluster;
    protected final Storage storage;
    protected final Serializer serializer;
    private MetaStore meta;
    private Log log;
    private SnapshotStore snapshot;
    private ServerStateMachine stateMachine;
    protected final ThreadContext stateContext;
    protected final ConnectionManager connections;
    protected ServerState state = new InactiveState(this);
    private Duration electionTimeout = Duration.ofMillis(500L);
    private Duration sessionTimeout = Duration.ofMillis(5000L);
    private Duration heartbeatInterval = Duration.ofMillis(150L);
    private Duration globalSuspendTimeout = Duration.ofHours(1L);
    private volatile int leader;
    private volatile long term;
    private int lastVotedFor;
    private long commitIndex;
    private long globalIndex;

    public ServerContext(String name, Member.Type type, Address serverAddress, Address clientAddress, Storage storage, Serializer serializer, Supplier<StateMachine> stateMachineFactory, ConnectionManager connections, ThreadContext threadContext) {
        this.name = Assert.notNull(name, "name");
        this.storage = Assert.notNull(storage, "storage");
        this.serializer = Assert.notNull(serializer, "serializer");
        this.threadContext = Assert.notNull(threadContext, "threadContext");
        this.connections = Assert.notNull(connections, "connections");
        this.stateMachineFactory = Assert.notNull(stateMachineFactory, "stateMachineFactory");
        this.stateContext = new SingleThreadContext(String.format("copycat-server-%s-%s-state", serverAddress, name), threadContext.serializer().clone());
        threadContext.execute(() -> {
            this.meta = storage.openMetaStore(name);
            return this.meta;
        }).join();
        this.term = this.meta.loadTerm();
        this.lastVotedFor = this.meta.loadVote();
        threadContext.execute(this::reset).join();
        this.cluster = new ClusterState(type, serverAddress, clientAddress, this);
    }

    public Listener<CopycatServer.State> onStateChange(Consumer<CopycatServer.State> listener) {
        return this.stateChangeListeners.add(listener);
    }

    public Listener<Member> onLeaderElection(Consumer<Member> listener) {
        return this.electionListeners.add(listener);
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    ConnectionManager getConnections() {
        return this.connections;
    }

    public ServerContext setElectionTimeout(Duration electionTimeout) {
        this.electionTimeout = electionTimeout;
        return this;
    }

    public Duration getElectionTimeout() {
        return this.electionTimeout;
    }

    public ServerContext setHeartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = Assert.notNull(heartbeatInterval, "heartbeatInterval");
        return this;
    }

    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    public ServerContext setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = Assert.notNull(sessionTimeout, "sessionTimeout");
        return this;
    }

    public Duration getGlobalSuspendTimeout() {
        return this.globalSuspendTimeout;
    }

    public ServerContext setGlobalSuspendTimeout(Duration globalSuspendTimeout) {
        this.globalSuspendTimeout = Assert.notNull(globalSuspendTimeout, "globalSuspendTimeout");
        return this;
    }

    ServerContext setLeader(int leader) {
        if (this.leader != leader) {
            if (leader == 0) {
                this.leader = 0;
            } else {
                ServerMember member = this.cluster.member(leader);
                if (member != null) {
                    this.leader = leader;
                    LOGGER.info("{} - Found leader {}", (Object)this.cluster.member().address(), (Object)member.address());
                    this.electionListeners.forEach(l -> l.accept(member));
                    this.cluster.identify();
                }
            }
            this.lastVotedFor = 0;
            this.meta.storeVote(0);
        }
        return this;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    ClusterState getClusterState() {
        return this.cluster;
    }

    ServerMember getLeader() {
        if (this.leader == 0) {
            return null;
        }
        return this.cluster.member(this.leader);
    }

    ServerContext setTerm(long term) {
        if (term > this.term) {
            this.term = term;
            this.leader = 0;
            this.lastVotedFor = 0;
            this.meta.storeTerm(this.term);
            this.meta.storeVote(this.lastVotedFor);
            LOGGER.debug("{} - Set term {}", (Object)this.cluster.member().address(), (Object)term);
        }
        return this;
    }

    long getTerm() {
        return this.term;
    }

    ServerContext setLastVotedFor(int candidate) {
        Assert.stateNot(this.lastVotedFor != 0 && (long)candidate != 0L, "Already voted for another candidate", new Object[0]);
        ServerMember member = this.cluster.member(candidate);
        Assert.state(member != null, "unknown candidate: %d", candidate);
        this.lastVotedFor = candidate;
        this.meta.storeVote(this.lastVotedFor);
        if (candidate != 0) {
            LOGGER.debug("{} - Voted for {}", (Object)this.cluster.member().address(), (Object)member.address());
        } else {
            LOGGER.trace("{} - Reset last voted for", (Object)this.cluster.member().address());
        }
        return this;
    }

    int getLastVotedFor() {
        return this.lastVotedFor;
    }

    ServerContext setCommitIndex(long commitIndex) {
        Assert.argNot(commitIndex < 0L, "commit index must be positive", new Object[0]);
        long previousCommitIndex = this.commitIndex;
        if (commitIndex > previousCommitIndex) {
            this.commitIndex = commitIndex;
            this.log.commit(Math.min(commitIndex, this.log.lastIndex()));
            long configurationIndex = this.cluster.getConfiguration().index();
            if (configurationIndex > previousCommitIndex && configurationIndex <= commitIndex) {
                this.cluster.commit();
            }
        }
        return this;
    }

    long getCommitIndex() {
        return this.commitIndex;
    }

    ServerContext setGlobalIndex(long globalIndex) {
        Assert.argNot(globalIndex < 0L, "global index must be positive", new Object[0]);
        this.globalIndex = Math.max(this.globalIndex, globalIndex);
        this.log.compactor().majorIndex(this.globalIndex - 1L);
        return this;
    }

    long getGlobalIndex() {
        return this.globalIndex;
    }

    public ServerStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public CopycatServer.State getState() {
        return this.state.type();
    }

    ServerState getServerState() {
        return this.state;
    }

    public MetaStore getMetaStore() {
        return this.meta;
    }

    public Log getLog() {
        return this.log;
    }

    ServerContext reset() {
        if (this.log != null) {
            this.log.close();
            this.storage.deleteLog(this.name);
        }
        if (this.snapshot != null) {
            this.snapshot.close();
            this.storage.deleteSnapshotStore(this.name);
        }
        this.log = this.storage.openLog(this.name);
        this.snapshot = this.storage.openSnapshotStore(this.name);
        StateMachine stateMachine = this.stateMachineFactory.get();
        if (stateMachine instanceof Snapshottable) {
            this.log.compactor().withDefaultCompactionMode(Compaction.Mode.SNAPSHOT);
        } else {
            this.log.compactor().withDefaultCompactionMode(Compaction.Mode.SEQUENTIAL);
        }
        this.stateMachine = new ServerStateMachine(stateMachine, this, this.stateContext);
        return this;
    }

    public SnapshotStore getSnapshotStore() {
        return this.snapshot;
    }

    void checkThread() {
        this.threadContext.checkThread();
    }

    public void connectClient(Connection connection) {
        this.threadContext.checkThread();
        connection.handler(RegisterRequest.class, request -> this.state.register((RegisterRequest)request));
        connection.handler(ConnectRequest.class, request -> this.state.connect((ConnectRequest)request, connection));
        connection.handler(KeepAliveRequest.class, request -> this.state.keepAlive((KeepAliveRequest)request));
        connection.handler(UnregisterRequest.class, request -> this.state.unregister((UnregisterRequest)request));
        connection.handler(ResetRequest.class, request -> this.state.reset((ResetRequest)request));
        connection.handler(CommandRequest.class, request -> this.state.command((CommandRequest)request));
        connection.handler(QueryRequest.class, request -> this.state.query((QueryRequest)request));
        connection.onClose(this.stateMachine.executor().context().sessions()::unregisterConnection);
    }

    public void connectServer(Connection connection) {
        this.threadContext.checkThread();
        connection.handler(RegisterRequest.class, request -> this.state.register((RegisterRequest)request));
        connection.handler(ConnectRequest.class, request -> this.state.connect((ConnectRequest)request, connection));
        connection.handler(KeepAliveRequest.class, request -> this.state.keepAlive((KeepAliveRequest)request));
        connection.handler(UnregisterRequest.class, request -> this.state.unregister((UnregisterRequest)request));
        connection.handler(ResetRequest.class, request -> this.state.reset((ResetRequest)request));
        connection.handler(ConfigureRequest.class, request -> this.state.configure((ConfigureRequest)request));
        connection.handler(InstallRequest.class, request -> this.state.install((InstallRequest)request));
        connection.handler(JoinRequest.class, request -> this.state.join((JoinRequest)request));
        connection.handler(ReconfigureRequest.class, request -> this.state.reconfigure((ReconfigureRequest)request));
        connection.handler(LeaveRequest.class, request -> this.state.leave((LeaveRequest)request));
        connection.handler(AppendRequest.class, request -> this.state.append((AppendRequest)request));
        connection.handler(PollRequest.class, request -> this.state.poll((PollRequest)request));
        connection.handler(VoteRequest.class, request -> this.state.vote((VoteRequest)request));
        connection.handler(CommandRequest.class, request -> this.state.command((CommandRequest)request));
        connection.handler(QueryRequest.class, request -> this.state.query((QueryRequest)request));
        connection.onClose(this.stateMachine.executor().context().sessions()::unregisterConnection);
    }

    protected void transition(Member.Type type) {
        switch (type) {
            case ACTIVE: {
                if (this.state instanceof ActiveState) break;
                this.transition(CopycatServer.State.FOLLOWER);
                break;
            }
            case PASSIVE: {
                if (this.state.type() == CopycatServer.State.PASSIVE) break;
                this.transition(CopycatServer.State.PASSIVE);
                break;
            }
            case RESERVE: {
                if (this.state.type() == CopycatServer.State.RESERVE) break;
                this.transition(CopycatServer.State.RESERVE);
                break;
            }
            default: {
                if (this.state.type() == CopycatServer.State.INACTIVE) break;
                this.transition(CopycatServer.State.INACTIVE);
            }
        }
    }

    public void transition(CopycatServer.State state) {
        this.checkThread();
        if (this.state != null && state == this.state.type()) {
            return;
        }
        LOGGER.info("{} - Transitioning to {}", (Object)this.cluster.member().address(), (Object)state);
        try {
            this.state.close().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to close Raft state", e);
        }
        try {
            this.state = this.createState(state);
            this.state.open().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to initialize Raft state", e);
        }
        this.stateChangeListeners.forEach(l -> l.accept(this.state.type()));
    }

    private AbstractState createState(CopycatServer.State state) {
        switch (state) {
            case INACTIVE: {
                return new InactiveState(this);
            }
            case RESERVE: {
                return new ReserveState(this);
            }
            case PASSIVE: {
                return new PassiveState(this);
            }
            case FOLLOWER: {
                return new FollowerState(this);
            }
            case CANDIDATE: {
                return new CandidateState(this);
            }
            case LEADER: {
                return new LeaderState(this);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() {
        try {
            this.log.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.meta.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.snapshot.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stateMachine.close();
        this.threadContext.close();
    }

    public void delete() {
        this.storage.deleteLog(this.name);
        this.storage.deleteSnapshotStore(this.name);
        this.storage.deleteMetaStore(this.name);
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }
}

