/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Operation;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.state.ServerCommitPool;
import io.atomix.copycat.server.state.ServerSessionContext;
import io.atomix.copycat.server.storage.Log;
import io.atomix.copycat.server.storage.entry.OperationEntry;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;

final class ServerCommit
implements Commit<Operation<?>> {
    private final ServerCommitPool pool;
    private final Log log;
    private final AtomicInteger references = new AtomicInteger();
    private volatile long index;
    private volatile ServerSessionContext session;
    private volatile Instant instant;
    private volatile Operation operation;

    public ServerCommit(ServerCommitPool pool, Log log) {
        this.pool = pool;
        this.log = log;
    }

    void reset(OperationEntry<?> entry, ServerSessionContext session, long timestamp) {
        if (!this.references.compareAndSet(0, 1)) {
            throw new IllegalStateException("Cannot recycle commit with " + this.references.get() + " references");
        }
        this.index = entry.getIndex();
        this.session = session;
        this.instant = Instant.ofEpochMilli(timestamp);
        this.operation = entry.getOperation();
        session.acquire();
        this.references.set(1);
    }

    private void checkOpen() {
        Assert.state(this.references.get() > 0, "commit not open", new Object[0]);
    }

    @Override
    public long index() {
        this.checkOpen();
        return this.index;
    }

    @Override
    public ServerSession session() {
        this.checkOpen();
        return this.session;
    }

    @Override
    public Instant time() {
        this.checkOpen();
        return this.instant;
    }

    @Override
    public Class type() {
        this.checkOpen();
        return this.operation != null ? this.operation.getClass() : null;
    }

    @Override
    public Operation<?> operation() {
        this.checkOpen();
        return this.operation;
    }

    @Override
    public Commit<Operation<?>> acquire() {
        this.references.incrementAndGet();
        return this;
    }

    @Override
    public boolean release() {
        if (this.references.decrementAndGet() == 0) {
            this.cleanup();
            return true;
        }
        return false;
    }

    @Override
    public int references() {
        return this.references.get();
    }

    @Override
    public void close() {
        if (this.references.get() > 0) {
            this.references.set(0);
            this.cleanup();
        }
    }

    private void cleanup() {
        if (this.operation instanceof Command && this.log.isOpen()) {
            try {
                this.log.release(this.index);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.session.release();
        this.index = 0L;
        this.session = null;
        this.instant = null;
        this.operation = null;
        this.pool.release(this);
    }

    protected void finalize() throws Throwable {
        this.pool.warn(this);
        super.finalize();
    }

    public String toString() {
        if (this.references() > 0) {
            return String.format("%s[index=%d, session=%s, time=%s, operation=%s]", this.getClass().getSimpleName(), this.index(), this.session(), this.time(), this.operation());
        }
        return String.format("%s[index=unknown]", this.getClass().getSimpleName());
    }
}

