/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import io.atomix.copycat.server.cluster.Member;
import java.util.Collection;
import java.util.Objects;

public class ConfigureRequest
extends AbstractRequest {
    private long term;
    private int leader;
    private long index;
    private long timestamp;
    private Collection<Member> members;

    public static Builder builder() {
        return new Builder(new ConfigureRequest());
    }

    public static Builder builder(ConfigureRequest request) {
        return new Builder(request);
    }

    public long term() {
        return this.term;
    }

    public int leader() {
        return this.leader;
    }

    public long index() {
        return this.index;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Collection<Member> members() {
        return this.members;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.term).writeInt(this.leader).writeLong(this.index).writeLong(this.timestamp);
        serializer.writeObject(this.members, buffer);
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.term = buffer.readLong();
        this.leader = buffer.readInt();
        this.index = buffer.readLong();
        this.timestamp = buffer.readLong();
        this.members = (Collection)serializer.readObject(buffer);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.term, this.leader, this.index, this.members);
    }

    public boolean equals(Object object) {
        if (object instanceof ConfigureRequest) {
            ConfigureRequest request = (ConfigureRequest)object;
            return request.term == this.term && request.leader == this.leader && request.index == this.index && request.timestamp == this.timestamp && request.members.equals(this.members);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[term=%d, leader=%d, index=%d, timestamp=%d, members=%s]", this.getClass().getSimpleName(), this.term, this.leader, this.index, this.timestamp, this.members);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, ConfigureRequest> {
        protected Builder(ConfigureRequest request) {
            super(request);
        }

        public Builder withTerm(long term) {
            ((ConfigureRequest)this.request).term = Assert.arg(term, term > 0L, "term must be positive", new Object[0]);
            return this;
        }

        public Builder withLeader(int leader) {
            ((ConfigureRequest)this.request).leader = leader;
            return this;
        }

        public Builder withIndex(long index) {
            ((ConfigureRequest)this.request).index = Assert.argNot(index, index < 0L, "index must be positive", new Object[0]);
            return this;
        }

        public Builder withTime(long timestamp) {
            ((ConfigureRequest)this.request).timestamp = Assert.argNot(timestamp, timestamp <= 0L, "timestamp must be positive", new Object[0]);
            return this;
        }

        public Builder withMembers(Collection<Member> members) {
            ((ConfigureRequest)this.request).members = Assert.notNull(members, "members");
            return this;
        }

        @Override
        public ConfigureRequest build() {
            super.build();
            Assert.stateNot(((ConfigureRequest)this.request).term <= 0L, "term must be positive", new Object[0]);
            Assert.argNot(((ConfigureRequest)this.request).index < 0L, "index must be positive", new Object[0]);
            Assert.notNull(((ConfigureRequest)this.request).members, "members");
            return (ConfigureRequest)this.request;
        }
    }
}

