/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.AbstractResponse;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.server.cluster.Member;
import java.util.Collection;
import java.util.Objects;

public abstract class ConfigurationResponse
extends AbstractResponse {
    protected long index;
    protected long term;
    protected long timestamp;
    protected Collection<Member> members;

    public long index() {
        return this.index;
    }

    public long term() {
        return this.term;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Collection<Member> members() {
        return this.members;
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        if (this.status == Response.Status.OK) {
            this.error = null;
            this.index = buffer.readLong();
            this.term = buffer.readLong();
            this.timestamp = buffer.readLong();
            this.members = (Collection)serializer.readObject(buffer);
        } else {
            int errorCode = buffer.readByte();
            if (errorCode != 0) {
                this.error = CopycatError.forId(errorCode);
            }
        }
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        buffer.writeByte(this.status.id());
        if (this.status == Response.Status.OK) {
            buffer.writeLong(this.index);
            buffer.writeLong(this.term);
            buffer.writeLong(this.timestamp);
            serializer.writeObject(this.members, buffer);
        } else {
            buffer.writeByte(this.error != null ? (int)this.error.id() : 0);
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.index, this.term, this.members});
    }

    public boolean equals(Object object) {
        if (this.getClass().isAssignableFrom(object.getClass())) {
            ConfigurationResponse response = (ConfigurationResponse)object;
            return response.status == this.status && response.index == this.index && response.term == this.term && response.timestamp == this.timestamp && response.members.equals(this.members);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s, error=%s, index=%d, term=%d, timestamp=%d, members=%s]", new Object[]{this.getClass().getSimpleName(), this.status, this.error, this.index, this.term, this.timestamp, this.members});
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends ConfigurationResponse>
    extends AbstractResponse.Builder<T, U> {
        protected Builder(U response) {
            super(response);
        }

        public T withIndex(long index) {
            ((ConfigurationResponse)this.response).index = Assert.argNot(index, index < 0L, "index cannot be negative", new Object[0]);
            return (T)this;
        }

        public T withTerm(long term) {
            ((ConfigurationResponse)this.response).term = Assert.argNot(term, term < 0L, "term must be positive", new Object[0]);
            return (T)this;
        }

        public T withTime(long time) {
            ((ConfigurationResponse)this.response).timestamp = Assert.argNot(time, time <= 0L, "timestamp cannot be negative", new Object[0]);
            return (T)this;
        }

        public T withMembers(Collection<Member> members) {
            ((ConfigurationResponse)this.response).members = Assert.notNull(members, "members");
            return (T)this;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.response);
        }

        @Override
        public boolean equals(Object object) {
            return this.getClass().isAssignableFrom(object.getClass()) && ((Builder)object).response.equals(this.response);
        }

        @Override
        public U build() {
            super.build();
            if (((ConfigurationResponse)this.response).status == Response.Status.OK) {
                Assert.state(((ConfigurationResponse)this.response).members != null, "activeMembers members cannot be null", new Object[0]);
            }
            return (U)((ConfigurationResponse)this.response);
        }

        @Override
        public String toString() {
            return String.format("%s[response=%s]", this.getClass().getCanonicalName(), this.response);
        }
    }
}

