/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.util;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.TransportException;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.client.util.AddressSelector;
import io.atomix.copycat.client.util.OrderedCompletableFuture;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.ConnectRequest;
import io.atomix.copycat.protocol.ConnectResponse;
import io.atomix.copycat.protocol.Request;
import io.atomix.copycat.protocol.Response;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnection
implements Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConnection.class);
    private final String id;
    private final Client client;
    private final AddressSelector selector;
    private CompletableFuture<Connection> connectFuture;
    private final Map<Class<?>, Function> handlers = new ConcurrentHashMap();
    private Connection connection;
    private boolean open = true;

    public ClientConnection(String id, Client client, AddressSelector selector) {
        this.id = Assert.notNull(id, "id");
        this.client = Assert.notNull(client, "client");
        this.selector = Assert.notNull(selector, "selector");
    }

    public Address leader() {
        return this.selector.leader();
    }

    public Collection<Address> servers() {
        return this.selector.servers();
    }

    public ClientConnection reset() {
        this.selector.reset();
        return this;
    }

    public ClientConnection reset(Address leader, Collection<Address> servers) {
        this.selector.reset(leader, servers);
        return this;
    }

    @Override
    public CompletableFuture<Void> send(Object request) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.sendRequest((Request)request, (r, c) -> c.send(r), future);
        return future;
    }

    @Override
    public <T, U> CompletableFuture<U> sendAndReceive(T request) {
        CompletableFuture future = new CompletableFuture();
        this.sendRequest((Request)request, (r, c) -> c.sendAndReceive(r), future);
        return future;
    }

    private <T extends Request, U> void sendRequest(T request, BiFunction<Request, Connection, CompletableFuture<U>> sender, CompletableFuture<U> future) {
        if (this.open) {
            this.connect().whenComplete((c, e) -> this.sendRequest(request, sender, (Connection)c, (Throwable)e, future));
        }
    }

    private <T extends Request, U> void sendRequest(T request, BiFunction<Request, Connection, CompletableFuture<U>> sender, Connection connection, Throwable error, CompletableFuture<U> future) {
        if (this.open) {
            if (error == null) {
                if (connection != null) {
                    LOGGER.trace("{} - Sending {}", (Object)this.id, request);
                    sender.apply(request, connection).whenComplete((r, e) -> {
                        if (e != null || r != null) {
                            this.handleResponse(request, sender, connection, (Response)r, (Throwable)e, future);
                        } else {
                            future.complete(null);
                        }
                    });
                } else {
                    future.completeExceptionally(new ConnectException("Failed to connect to the cluster"));
                }
            } else {
                LOGGER.trace("{} - Resending {}: {}", new Object[]{this.id, request, error});
                this.resendRequest(error, request, sender, connection, future);
            }
        }
    }

    private <T extends Request> void resendRequest(Throwable cause, T request, BiFunction sender, Connection connection, CompletableFuture future) {
        if (this.connection == connection) {
            LOGGER.trace("{} - Resetting connection. Reason: {}", (Object)this.id, (Object)cause);
            this.connection = null;
            connection.close();
        }
        this.connect().whenComplete((c, e) -> this.sendRequest(request, sender, (Connection)c, (Throwable)e, future));
    }

    private <T extends Request> void handleResponse(T request, BiFunction sender, Connection connection, Response response, Throwable error, CompletableFuture future) {
        if (this.open) {
            if (error == null) {
                if (response.status() == Response.Status.OK || response.error() == CopycatError.Type.COMMAND_ERROR || response.error() == CopycatError.Type.QUERY_ERROR || response.error() == CopycatError.Type.APPLICATION_ERROR || response.error() == CopycatError.Type.UNKNOWN_SESSION_ERROR || response.error() == CopycatError.Type.INTERNAL_ERROR) {
                    LOGGER.trace("{} - Received {}", (Object)this.id, (Object)response);
                    future.complete(response);
                } else {
                    this.resendRequest(response.error().createException(), request, sender, connection, future);
                }
            } else if (error instanceof ConnectException || error instanceof TimeoutException || error instanceof TransportException || error instanceof ClosedChannelException) {
                this.resendRequest(error, request, sender, connection, future);
            } else {
                LOGGER.debug("{} - {} failed! Reason: {}", new Object[]{this.id, request, error});
                future.completeExceptionally(error);
            }
        }
    }

    private CompletableFuture<Connection> connect() {
        if (this.selector.state() == AddressSelector.State.RESET && this.connection != null) {
            if (this.connectFuture != null) {
                return this.connectFuture;
            }
            OrderedCompletableFuture<Connection> future = new OrderedCompletableFuture<Connection>();
            ((CompletableFuture)future).whenComplete((r, e) -> {
                this.connectFuture = null;
            });
            this.connectFuture = future;
            Connection oldConnection = this.connection;
            this.connection = null;
            oldConnection.close();
            this.connect(future);
            return future;
        }
        if (this.connection != null) {
            return CompletableFuture.completedFuture(this.connection);
        }
        if (this.connectFuture != null) {
            return this.connectFuture;
        }
        OrderedCompletableFuture<Connection> future = new OrderedCompletableFuture<Connection>();
        ((CompletableFuture)future).whenComplete((r, e) -> {
            this.connectFuture = null;
        });
        this.connectFuture = future;
        this.reset().connect(future);
        return future;
    }

    private void connect(CompletableFuture<Connection> future) {
        if (!this.selector.hasNext()) {
            LOGGER.debug("{} - Failed to connect to the cluster", (Object)this.id);
            future.complete(null);
        } else {
            Address address = this.selector.next();
            LOGGER.debug("{} - Connecting to {}", (Object)this.id, (Object)address);
            this.client.connect(address).whenComplete((c, e) -> this.handleConnection(address, (Connection)c, (Throwable)e, future));
        }
    }

    private void handleConnection(Address address, Connection connection, Throwable error, CompletableFuture<Connection> future) {
        if (this.open) {
            if (error == null) {
                this.setupConnection(address, connection, future);
            } else {
                LOGGER.debug("{} - Failed to connect! Reason: {}", (Object)this.id, (Object)error);
                this.connect(future);
            }
        }
    }

    private void setupConnection(Address address, Connection connection, CompletableFuture<Connection> future) {
        LOGGER.debug("{} - Setting up connection to {}", (Object)this.id, (Object)address);
        this.connection = connection;
        connection.onClose(c -> {
            if (c.equals(this.connection)) {
                LOGGER.debug("{} - Connection closed", (Object)this.id);
                this.connection = null;
            }
        });
        connection.onException(c -> {
            if (c.equals(this.connection)) {
                LOGGER.debug("{} - Connection lost", (Object)this.id);
                this.connection = null;
            }
        });
        for (Map.Entry<Class<?>, Function> entry : this.handlers.entrySet()) {
            connection.handler(entry.getKey(), entry.getValue());
        }
        ConnectRequest request = ConnectRequest.builder().withClientId(this.id).build();
        LOGGER.trace("{} - Sending {}", (Object)this.id, (Object)request);
        connection.sendAndReceive(request).whenComplete((r, e) -> this.handleConnectResponse((ConnectResponse)r, (Throwable)e, future));
    }

    private void handleConnectResponse(ConnectResponse response, Throwable error, CompletableFuture<Connection> future) {
        if (this.open) {
            if (error == null) {
                LOGGER.trace("{} - Received {}", (Object)this.id, (Object)response);
                if (response.status() == Response.Status.OK) {
                    this.selector.reset(response.leader(), response.members());
                    future.complete(this.connection);
                } else {
                    this.connect(future);
                }
            } else {
                LOGGER.debug("{} - Failed to connect! Reason: {}", (Object)this.id, (Object)error);
                this.connect(future);
            }
        }
    }

    @Override
    public <T, U> Connection handler(Class<T> type, Consumer<T> handler) {
        return this.handler(type, (T r) -> {
            handler.accept(r);
            return null;
        });
    }

    @Override
    public <T, U> Connection handler(Class<T> type, Function<T, CompletableFuture<U>> handler) {
        Assert.notNull(type, "type");
        Assert.notNull(handler, "handler");
        this.handlers.put(type, handler);
        if (this.connection != null) {
            this.connection.handler(type, handler);
        }
        return this;
    }

    @Override
    public Listener<Throwable> onException(Consumer<Throwable> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Listener<Connection> onClose(Consumer<Connection> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Void> close() {
        this.open = false;
        return CompletableFuture.completedFuture(null);
    }
}

