/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.concurrent;

import io.atomix.catalyst.concurrent.BlockingFuture;
import io.atomix.concurrent.internal.LockCommands;
import io.atomix.concurrent.util.DistributedLockFactory;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@ResourceTypeInfo(id=-22, factory=DistributedLockFactory.class)
public class DistributedLock
extends AbstractResource<DistributedLock> {
    private final Map<Integer, CompletableFuture<Long>> futures = new ConcurrentHashMap<Integer, CompletableFuture<Long>>();
    private final AtomicInteger id = new AtomicInteger();
    private int lock;

    public DistributedLock(CopycatClient client, Properties options) {
        super(client, options);
    }

    @Override
    public CompletableFuture<DistributedLock> open() {
        return super.open().thenApply(result -> {
            this.client.onEvent("lock", this::handleEvent);
            this.client.onEvent("fail", this::handleFail);
            return result;
        });
    }

    private void handleEvent(LockCommands.LockEvent event) {
        CompletableFuture<Long> future = this.futures.remove(event.id());
        if (future != null) {
            this.lock = event.id();
            future.complete(event.version());
        }
    }

    private void handleFail(LockCommands.LockEvent event) {
        CompletableFuture<Long> future = this.futures.remove(event.id());
        if (future != null) {
            future.complete(null);
        }
    }

    public CompletableFuture<Long> lock() {
        BlockingFuture<Long> future = new BlockingFuture<Long>();
        int id = this.id.incrementAndGet();
        this.futures.put(id, future);
        this.client.submit(new LockCommands.Lock(id, -1L)).whenComplete((result, error) -> {
            if (error != null) {
                this.futures.remove(id);
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    public CompletableFuture<Long> tryLock() {
        BlockingFuture<Long> future = new BlockingFuture<Long>();
        int id = this.id.incrementAndGet();
        this.futures.put(id, future);
        this.client.submit(new LockCommands.Lock(id, 0L)).whenComplete((result, error) -> {
            if (error != null) {
                this.futures.remove(id);
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    public CompletableFuture<Long> tryLock(Duration timeout) {
        BlockingFuture<Long> future = new BlockingFuture<Long>();
        int id = this.id.incrementAndGet();
        this.futures.put(id, future);
        this.client.submit(new LockCommands.Lock(id, timeout.toMillis())).whenComplete((result, error) -> {
            if (error != null) {
                this.futures.remove(id);
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    public CompletableFuture<Void> unlock() {
        int lock = this.lock;
        this.lock = 0;
        if (lock != 0) {
            return this.client.submit(new LockCommands.Unlock(lock));
        }
        return CompletableFuture.completedFuture(null);
    }
}

