/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections.internal;

import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.collections.DistributedMap;
import io.atomix.collections.internal.MapCommands;
import io.atomix.collections.internal.MapEntry;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.resource.ResourceStateMachine;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MapState
extends ResourceStateMachine {
    private final Map<Object, Value> map = new HashMap<Object, Value>();
    private final Map<Object, Map<Integer, Map<Long, Commit<MapCommands.KeyListen>>>> listeners = new HashMap<Object, Map<Integer, Map<Long, Commit<MapCommands.KeyListen>>>>();

    public MapState(Properties config) {
        super(config);
    }

    @Override
    public void close(ServerSession session) {
        Iterator<Map.Entry<Object, Map<Integer, Map<Long, Commit<MapCommands.KeyListen>>>>> keyIterator = this.listeners.entrySet().iterator();
        while (keyIterator.hasNext()) {
            Map.Entry<Object, Map<Integer, Map<Long, Commit<MapCommands.KeyListen>>>> keyEntry = keyIterator.next();
            Iterator<Map.Entry<Integer, Map<Long, Commit<MapCommands.KeyListen>>>> eventIterator = keyEntry.getValue().entrySet().iterator();
            while (eventIterator.hasNext()) {
                Map.Entry<Integer, Map<Long, Commit<MapCommands.KeyListen>>> eventEntry = eventIterator.next();
                Map<Long, Commit<MapCommands.KeyListen>> sessions = eventEntry.getValue();
                Commit<MapCommands.KeyListen> commit = sessions.remove(session.id());
                if (commit == null) continue;
                commit.release();
                if (!sessions.isEmpty()) continue;
                eventIterator.remove();
            }
            if (!keyEntry.getValue().isEmpty()) continue;
            keyIterator.remove();
        }
    }

    protected void notify(DistributedMap.EntryEvent event) {
        Map<Long, Commit<MapCommands.KeyListen>> eventListeners;
        Map<Integer, Map<Long, Commit<MapCommands.KeyListen>>> keyListeners = this.listeners.get(event.entry().getKey());
        if (keyListeners != null && (eventListeners = keyListeners.get(event.type().id())) != null) {
            for (Commit<MapCommands.KeyListen> listener : eventListeners.values()) {
                listener.session().publish("key", event);
            }
        }
        super.notify(event);
    }

    public void listen(Commit<MapCommands.KeyListen> commit) {
        Map listeners = this.listeners.computeIfAbsent(commit.command().key(), k -> new HashMap());
        Map sessions = listeners.computeIfAbsent(commit.command().event(), e -> new HashMap());
        if (!sessions.containsKey(commit.session().id())) {
            sessions.put(commit.session().id(), commit);
        } else {
            commit.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlisten(Commit<MapCommands.KeyUnlisten> commit) {
        try {
            Commit<MapCommands.KeyListen> listen;
            Map<Long, Commit<MapCommands.KeyListen>> sessions;
            Map<Integer, Map<Long, Commit<MapCommands.KeyListen>>> listeners = this.listeners.get(commit.command().key());
            if (listeners != null && (sessions = listeners.get(commit.command().event())) != null && (listen = sessions.remove(commit.session().id())) != null) {
                listen.release();
                if (sessions.isEmpty()) {
                    listeners.remove(commit.command().event());
                    if (listeners.isEmpty()) {
                        this.listeners.remove(commit.command().key());
                    }
                }
            }
        }
        finally {
            commit.release();
        }
    }

    public boolean containsKey(Commit<MapCommands.ContainsKey> commit) {
        try {
            boolean bl = this.map.containsKey(commit.operation().key());
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Commit<MapCommands.ContainsValue> commit) {
        try {
            for (Value value : this.map.values()) {
                if (!((MapCommands.TtlCommand)value.commit.operation()).value().equals(commit.operation().value())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Commit<MapCommands.Get> commit) {
        try {
            Value value = this.map.get(commit.operation().key());
            Object object = value != null ? ((MapCommands.TtlCommand)value.commit.operation()).value() : null;
            return object;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOrDefault(Commit<MapCommands.GetOrDefault> commit) {
        try {
            Value value = this.map.get(commit.operation().key());
            Object object = value != null ? ((MapCommands.TtlCommand)value.commit.operation()).value() : commit.operation().defaultValue();
            return object;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object put(Commit<MapCommands.Put> commit) {
        try {
            Object key = commit.command().key();
            long ttl = commit.command().ttl();
            Scheduled timer = ttl > 0L ? this.executor.schedule(Duration.ofMillis(ttl), () -> {
                Value removed = this.map.remove(key);
                if (removed != null) {
                    this.notify(new DistributedMap.EntryEvent<Object, Object>(DistributedMap.Events.REMOVE, new MapEntry<Object, Object>(key, ((MapCommands.TtlCommand)removed.commit.command()).value())));
                    removed.commit.close();
                }
            }) : null;
            Value value = this.map.put(key, new Value(commit, timer));
            if (value == null) {
                this.notify(new DistributedMap.EntryEvent<Object, Object>(DistributedMap.Events.ADD, new MapEntry<Object, Object>(key, commit.operation().value())));
                return null;
            }
            try {
                if (value.timer != null) {
                    value.timer.cancel();
                }
                this.notify(new DistributedMap.EntryEvent<Object, Object>(DistributedMap.Events.UPDATE, new MapEntry<Object, Object>(key, commit.operation().value())));
                Object object = ((MapCommands.TtlCommand)value.commit.operation()).value();
                return object;
            }
            finally {
                value.commit.close();
            }
        }
        catch (Exception e) {
            commit.close();
            throw e;
        }
    }

    public Object putIfAbsent(Commit<MapCommands.PutIfAbsent> commit) {
        try {
            Object key = commit.command().key();
            long ttl = commit.command().ttl();
            Value value = this.map.get(key);
            if (value == null) {
                Scheduled timer = ttl > 0L ? this.executor.schedule(Duration.ofMillis(ttl), () -> {
                    Value removed = this.map.remove(key);
                    if (removed != null) {
                        this.notify(new DistributedMap.EntryEvent<Object, Object>(DistributedMap.Events.REMOVE, new MapEntry<Object, Object>(key, ((MapCommands.TtlCommand)removed.commit.command()).value())));
                        removed.commit.close();
                    }
                }) : null;
                this.map.put(key, new Value(commit, timer));
                this.notify(new DistributedMap.EntryEvent<Object, Object>(DistributedMap.Events.ADD, new MapEntry<Object, Object>(key, commit.command().value())));
                return null;
            }
            commit.close();
            return ((MapCommands.TtlCommand)value.commit.command()).value();
        }
        catch (Exception e) {
            commit.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Commit<MapCommands.Remove> commit) {
        try {
            Value value = this.map.remove(commit.operation().key());
            if (value != null) {
                try {
                    if (value.timer != null) {
                        value.timer.cancel();
                    }
                    this.notify(new DistributedMap.EntryEvent<Object, Object>(DistributedMap.Events.REMOVE, new MapEntry<Object, Object>(((MapCommands.TtlCommand)value.commit.operation()).key(), ((MapCommands.TtlCommand)value.commit.operation()).value())));
                    Object object = ((MapCommands.TtlCommand)value.commit.operation()).value();
                    return object;
                }
                finally {
                    value.commit.close();
                }
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIfPresent(Commit<MapCommands.RemoveIfPresent> commit) {
        try {
            Value value = this.map.get(commit.operation().key());
            if (value == null || ((MapCommands.TtlCommand)value.commit.operation()).value() == null && commit.operation().value() != null || ((MapCommands.TtlCommand)value.commit.operation()).value() != null && !((MapCommands.TtlCommand)value.commit.operation()).value().equals(commit.operation().value())) {
                boolean bl = false;
                return bl;
            }
            try {
                this.map.remove(commit.operation().key());
                if (value.timer != null) {
                    value.timer.cancel();
                }
                this.notify(new DistributedMap.EntryEvent<Object, Object>(DistributedMap.Events.REMOVE, new MapEntry<Object, Object>(((MapCommands.TtlCommand)value.commit.operation()).key(), ((MapCommands.TtlCommand)value.commit.operation()).value())));
                boolean bl = true;
                value.commit.close();
                return bl;
            }
            catch (Throwable throwable) {
                value.commit.close();
                throw throwable;
            }
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object replace(Commit<MapCommands.Replace> commit) {
        Value value = this.map.get(commit.operation().key());
        if (value != null) {
            try {
                Object key = commit.command().key();
                long ttl = commit.command().ttl();
                if (value.timer != null) {
                    value.timer.cancel();
                }
                Scheduled timer = ttl > 0L ? this.executor.schedule(Duration.ofMillis(ttl), () -> {
                    Value removed = this.map.remove(key);
                    if (removed != null) {
                        this.notify(new DistributedMap.EntryEvent<Object, Object>(DistributedMap.Events.REMOVE, new MapEntry<Object, Object>(key, ((MapCommands.TtlCommand)removed.commit.command()).value())));
                        removed.commit.close();
                    }
                }) : null;
                this.map.put(key, new Value(commit, timer));
                this.notify(new DistributedMap.EntryEvent<Object, Object>(DistributedMap.Events.UPDATE, new MapEntry<Object, Object>(key, commit.command().value())));
                Object object = ((MapCommands.TtlCommand)value.commit.operation()).value();
                return object;
            }
            finally {
                value.commit.close();
            }
        }
        commit.close();
        return null;
    }

    public boolean replaceIfPresent(Commit<MapCommands.ReplaceIfPresent> commit) {
        Object key = commit.command().key();
        Value value = this.map.get(key);
        if (value == null) {
            commit.close();
            return false;
        }
        if (((MapCommands.TtlCommand)value.commit.operation()).value() == null && commit.operation().replace() == null || ((MapCommands.TtlCommand)value.commit.operation()).value() != null && ((MapCommands.TtlCommand)value.commit.operation()).value().equals(commit.operation().replace())) {
            long ttl;
            if (value.timer != null) {
                value.timer.cancel();
            }
            Scheduled timer = (ttl = commit.command().ttl()) > 0L ? this.executor.schedule(Duration.ofMillis(ttl), () -> {
                Value removed = this.map.remove(key);
                if (removed != null) {
                    this.notify(new DistributedMap.EntryEvent<Object, Object>(DistributedMap.Events.REMOVE, new MapEntry<Object, Object>(key, ((MapCommands.TtlCommand)removed.commit.command()).value())));
                    removed.commit.close();
                }
            }) : null;
            this.map.put(key, new Value(commit, timer));
            this.notify(new DistributedMap.EntryEvent<Object, Object>(DistributedMap.Events.UPDATE, new MapEntry<Object, Object>(key, commit.operation().value())));
            value.commit.close();
            return true;
        }
        commit.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> values(Commit<MapCommands.Values> commit) {
        try {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Value value : this.map.values()) {
                values.add(((MapCommands.TtlCommand)value.commit.operation()).value());
            }
            ArrayList<Object> arrayList = values;
            return arrayList;
        }
        finally {
            commit.close();
        }
    }

    public Set<Object> keySet(Commit<MapCommands.KeySet> commit) {
        try {
            HashSet<Object> hashSet = new HashSet<Object>(this.map.keySet());
            return hashSet;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<Object, Object>> entrySet(Commit<MapCommands.EntrySet> commit) {
        try {
            HashSet<MapEntry<Object, Object>> entries = new HashSet<MapEntry<Object, Object>>();
            for (Map.Entry<Object, Value> entry : this.map.entrySet()) {
                entries.add(new MapEntry<Object, Object>(entry.getKey(), ((MapCommands.TtlCommand)entry.getValue().commit.operation()).value()));
            }
            HashSet<MapEntry<Object, Object>> hashSet = entries;
            return hashSet;
        }
        finally {
            commit.close();
        }
    }

    public int size(Commit<MapCommands.Size> commit) {
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            commit.close();
        }
    }

    public boolean isEmpty(Commit<MapCommands.IsEmpty> commit) {
        try {
            boolean bl = this.map == null || this.map.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    public void clear(Commit<MapCommands.Clear> commit) {
        try {
            this.delete();
        }
        finally {
            commit.close();
        }
    }

    @Override
    public void delete() {
        Iterator<Map.Entry<Object, Value>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Value> entry = iterator.next();
            Value value = entry.getValue();
            if (value.timer != null) {
                value.timer.cancel();
            }
            value.commit.close();
            iterator.remove();
        }
    }

    private static class Value {
        private final Commit<? extends MapCommands.TtlCommand> commit;
        private final Scheduled timer;

        private Value(Commit<? extends MapCommands.TtlCommand> commit, Scheduled timer) {
            this.commit = commit;
            this.timer = timer;
        }
    }
}

