/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.internal.MultiMapCommands;
import io.atomix.collections.util.DistributedMultiMapFactory;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;

@ResourceTypeInfo(id=-12, factory=DistributedMultiMapFactory.class)
public class DistributedMultiMap<K, V>
extends AbstractResource<DistributedMultiMap<K, V>> {
    public DistributedMultiMap(CopycatClient client, Properties options) {
        super(client, options);
    }

    @Override
    public Resource.Config config() {
        return new Config(super.config());
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.client.submit(new MultiMapCommands.IsEmpty());
    }

    public CompletableFuture<Boolean> isEmpty(ReadConsistency consistency) {
        return this.client.submit(new MultiMapCommands.IsEmpty(consistency.level()));
    }

    public CompletableFuture<Integer> size() {
        return this.client.submit(new MultiMapCommands.Size());
    }

    public CompletableFuture<Integer> size(ReadConsistency consistency) {
        return this.client.submit(new MultiMapCommands.Size((Object)consistency.level()));
    }

    public CompletableFuture<Integer> size(K key) {
        return this.client.submit(new MultiMapCommands.Size(key));
    }

    public CompletableFuture<Integer> size(K key, ReadConsistency consistency) {
        return this.client.submit(new MultiMapCommands.Size(key, consistency.level()));
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.client.submit(new MultiMapCommands.ContainsKey(key));
    }

    public CompletableFuture<Boolean> containsKey(K key, ReadConsistency consistency) {
        return this.client.submit(new MultiMapCommands.ContainsKey(key, consistency.level()));
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        return this.client.submit(new MultiMapCommands.ContainsEntry(key, value));
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value, ReadConsistency consistency) {
        return this.client.submit(new MultiMapCommands.ContainsEntry(key, value, consistency.level()));
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return this.client.submit(new MultiMapCommands.ContainsValue(value));
    }

    public CompletableFuture<Boolean> containsValue(V value, ReadConsistency consistency) {
        return this.client.submit(new MultiMapCommands.ContainsValue(value, consistency.level()));
    }

    public CompletableFuture<Collection<V>> get(K key) {
        return this.client.submit(new MultiMapCommands.Get(key)).thenApply(result -> result);
    }

    public CompletableFuture<Collection<V>> get(K key, ReadConsistency consistency) {
        return this.client.submit(new MultiMapCommands.Get(key, consistency.level())).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> put(K key, V value) {
        return this.client.submit(new MultiMapCommands.Put(key, value)).thenApply(result -> result);
    }

    public CompletableFuture<Boolean> put(K key, V value, Duration ttl) {
        return this.client.submit(new MultiMapCommands.Put(key, value, ttl.toMillis()));
    }

    public CompletableFuture<Collection<V>> remove(Object key) {
        return this.client.submit(new MultiMapCommands.Remove(key)).thenApply(result -> (Collection)result);
    }

    public CompletableFuture<Boolean> remove(Object key, Object value) {
        return this.client.submit(new MultiMapCommands.Remove(key, value)).thenApply(result -> (boolean)((Boolean)result));
    }

    public CompletableFuture<Void> removeValue(Object value) {
        return this.client.submit(new MultiMapCommands.RemoveValue(value));
    }

    public CompletableFuture<Void> clear() {
        return this.client.submit(new MultiMapCommands.Clear());
    }

    public static enum Order {
        NATURAL,
        INSERT,
        NONE;

    }

    public static class Config
    extends Resource.Config {
        public Config() {
        }

        public Config(Properties defaults) {
            super(defaults);
        }

        public Config withValueOrder(Order order) {
            this.setProperty("order", order.name().toLowerCase());
            return this;
        }

        public Order getValueOrder() {
            return Order.valueOf(this.getProperty("order", Order.INSERT.name().toLowerCase()).toUpperCase());
        }
    }
}

