/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer.util;

import io.atomix.catalyst.buffer.util.HeapMemory;
import io.atomix.catalyst.buffer.util.MemoryAllocator;
import io.atomix.catalyst.buffer.util.NativeMemory;

public class HeapMemoryAllocator
implements MemoryAllocator<HeapMemory> {
    @Override
    public HeapMemory allocate(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size cannot be greater than 2147483647");
        }
        return new HeapMemory(new byte[(int)size], this);
    }

    @Override
    public HeapMemory reallocate(HeapMemory memory, long size) {
        HeapMemory copy = this.allocate(size);
        NativeMemory.UNSAFE.copyMemory(memory.array(), HeapMemory.ARRAY_BASE_OFFSET, copy.array(), HeapMemory.ARRAY_BASE_OFFSET, Math.min(size, memory.size()));
        memory.free();
        return copy;
    }
}

