/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.validators.BaseValidatorTest;
import io.atlasmap.validators.StringLengthValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StringLengthValidatorTest
extends BaseValidatorTest {
    private StringLengthValidator validator;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.validator = new StringLengthValidator(ValidationScope.MAPPING, "Must be of this length", 1, 10);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.validator = null;
    }

    @Test
    public void testSupported() {
        Assertions.assertTrue((boolean)this.validator.supports(String.class));
    }

    @Test
    public void testUnsupported() {
        Assertions.assertFalse((boolean)this.validator.supports(Integer.class));
    }

    @Test
    public void testValidate() {
        String pass = "1112332";
        this.validator.validate((Object)pass, this.validations, "testValidate");
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
    }

    @Test
    public void testValidateInvalid() {
        String pass = "";
        this.validator.validate((Object)pass, this.validations, "testValidateInvalid");
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
        Assertions.assertEquals((Integer)1, (Integer)this.validationHelper.getAllValidations().size());
        Validation validation = (Validation)this.validations.get(0);
        Assertions.assertNotNull((Object)validation);
        Assertions.assertEquals((Object)ValidationScope.MAPPING, (Object)validation.getScope());
        Assertions.assertEquals((Object)"testValidateInvalid", (Object)validation.getId());
        Assertions.assertTrue((boolean)"Must be of this length".equals(validation.getMessage()));
    }
}

