/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.LookupTables;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.validators.BaseValidatorTest;
import io.atlasmap.validators.LookupTableNameValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LookupTableNameValidatorTest
extends BaseValidatorTest {
    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.validator = new LookupTableNameValidator("LookupTables contain duplicated LookupTable names.");
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.validator = null;
    }

    @Test
    public void testSupportsLookupTables() {
        LookupTables lookupTables = this.makeLookupTables();
        Assertions.assertTrue((boolean)this.validator.supports(lookupTables.getClass()));
    }

    @Test
    public void testValidateDuplicatedNames() {
        LookupTables lookupTables = this.makeLookupTables();
        this.validator.validate((Object)lookupTables, this.validations, null);
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
        Assertions.assertEquals((Object)ValidationScope.LOOKUP_TABLE, (Object)((Validation)this.validationHelper.getValidation().get(0)).getScope());
        Assertions.assertNull((Object)((Validation)this.validationHelper.getValidation().get(0)).getId());
        this.debugErrors(this.validationHelper);
    }

    @Test
    public void testValidateNoDuplicateNames() {
        LookupTables lookupTables = this.makeLookupTables();
        lookupTables.getLookupTable().remove(2);
        this.validator.validate((Object)lookupTables, this.validations, null);
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
    }

    private LookupTables makeLookupTables() {
        LookupTables lookupTables = new LookupTables();
        LookupTable lookupTable = new LookupTable();
        LookupTable lookupTable2 = new LookupTable();
        LookupTable lookupTableDup = new LookupTable();
        lookupTable.setName("qwerty");
        lookupTable2.setName("anotherName");
        lookupTableDup.setName("qwerty");
        lookupTables.getLookupTable().add(lookupTable);
        lookupTables.getLookupTable().add(lookupTable2);
        lookupTables.getLookupTable().add(lookupTableDup);
        return lookupTables;
    }
}

