/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.AtlasTestData;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.Validations;
import java.net.URI;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasSessionTest {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasSessionTest.class);
    private DefaultAtlasSession session = null;

    @BeforeEach
    public void setUp() throws Exception {
        DefaultAtlasContext context = new DefaultAtlasContext(DefaultAtlasContextFactory.getInstance(), AtlasTestData.generateAtlasMapping());
        this.session = new DefaultAtlasSession(context);
    }

    @AfterEach
    public void tearDown() {
        this.session = null;
    }

    @Test
    public void testInitializeDefaultAtlasSession() {
        Assertions.assertNotNull((Object)this.session);
        Assertions.assertNotNull((Object)this.session.getMapping());
        Assertions.assertNotNull((Object)this.session.getAtlasContext());
        Assertions.assertNotNull((Object)this.session.getAudits());
        Assertions.assertNotNull((Object)this.session.getProperties());
        Assertions.assertNotNull((Object)this.session.getValidations());
        Assertions.assertNull((Object)this.session.getDefaultSourceDocument());
        Assertions.assertNull((Object)this.session.getDefaultTargetDocument());
    }

    @Test
    public void testGetSetAtlasContext() throws Exception {
        this.session.setAtlasContext((AtlasContext)new DefaultAtlasContext(new URI("file:foo")));
        Assertions.assertNotNull((Object)this.session.getAtlasContext());
        Assertions.assertTrue((boolean)(this.session.getAtlasContext() instanceof DefaultAtlasContext));
    }

    @Test
    public void testGetMapping() {
        Assertions.assertNotNull((Object)this.session.getMapping());
        Assertions.assertNotNull((Object)this.session.getMapping().getProperties());
        Assertions.assertNotNull((Object)this.session.getMapping().getProperties().getProperty());
        Assertions.assertTrue((this.session.getMapping().getProperties().getProperty().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSetValidations() {
        Assertions.assertNotNull((Object)this.session.getValidations());
        Assertions.assertNotNull((Object)this.session.getValidations().getValidation());
        Assertions.assertTrue((this.session.getValidations().getValidation().size() == 0 ? 1 : 0) != 0);
        Validations validations = new Validations();
        Validation validation = new Validation();
        validation.setScope(ValidationScope.MAPPING);
        validation.setId("bar");
        validations.getValidation().add(validation);
        this.session.setValidations(validations);
        Assertions.assertNotNull((Object)this.session.getValidations());
        Assertions.assertNotNull((Object)this.session.getValidations().getValidation());
        Assertions.assertTrue((this.session.getValidations().getValidation().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSetAudits() {
        Assertions.assertNotNull((Object)this.session.getAudits());
        Assertions.assertNotNull((Object)this.session.getAudits().getAudit());
        Assertions.assertTrue((this.session.getAudits().getAudit().size() == 0 ? 1 : 0) != 0);
        Audits audits = new Audits();
        Audit audit = new Audit();
        audit.setStatus(AuditStatus.INFO);
        audit.setMessage("hello");
        audits.getAudit().add(audit);
        this.session.setAudits(audits);
        Assertions.assertNotNull((Object)this.session.getAudits());
        Assertions.assertNotNull((Object)this.session.getAudits().getAudit());
        Assertions.assertTrue((this.session.getAudits().getAudit().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSetInput() {
        this.session.setDefaultSourceDocument((Object)new String("defaultInput"));
        Assertions.assertNotNull((Object)this.session.getDefaultSourceDocument());
        Assertions.assertTrue((boolean)(this.session.getDefaultSourceDocument() instanceof String));
        Assertions.assertEquals((Object)"defaultInput", (Object)this.session.getDefaultSourceDocument());
    }

    @Test
    public void testGetSetInputDocId() {
        this.session.setDefaultSourceDocument((Object)new String("defaultInput"));
        Assertions.assertNotNull((Object)this.session.getDefaultSourceDocument());
        Assertions.assertTrue((boolean)(this.session.getDefaultSourceDocument() instanceof String));
        Assertions.assertEquals((Object)"defaultInput", (Object)this.session.getDefaultSourceDocument());
        Assertions.assertNotNull((Object)this.session.getSourceDocument(null));
        Assertions.assertNotNull((Object)this.session.getSourceDocument(""));
        Assertions.assertNotNull((Object)this.session.getSourceDocument("docId"));
        this.session.setSourceDocument("second", (Object)new String("secondInput"));
        Assertions.assertNotNull((Object)this.session.getDefaultSourceDocument());
        Assertions.assertTrue((boolean)(this.session.getDefaultSourceDocument() instanceof String));
        Assertions.assertEquals((Object)"defaultInput", (Object)this.session.getDefaultSourceDocument());
        Assertions.assertTrue((boolean)this.session.hasSourceDocument("second"));
        Assertions.assertFalse((boolean)this.session.hasSourceDocument("third"));
        Assertions.assertTrue((boolean)this.session.hasSourceDocument(null));
        Assertions.assertTrue((boolean)this.session.hasSourceDocument(""));
        Assertions.assertNotNull((Object)this.session.getSourceDocument("second"));
        Assertions.assertTrue((boolean)(this.session.getSourceDocument("second") instanceof String));
        Assertions.assertEquals((Object)"secondInput", (Object)this.session.getSourceDocument("second"));
        Assertions.assertNull((Object)this.session.getSourceDocument("docId"));
        Assertions.assertNotNull((Object)this.session.getSourceDocumentMap());
    }

    @Test
    public void testGetSetOutput() {
        this.session.setDefaultTargetDocument((Object)new String("defaultOutput"));
        Assertions.assertNotNull((Object)this.session.getDefaultTargetDocument());
        Assertions.assertTrue((boolean)(this.session.getDefaultTargetDocument() instanceof String));
        Assertions.assertEquals((Object)"defaultOutput", (Object)this.session.getDefaultTargetDocument());
    }

    @Test
    public void testGetSetOutputDocId() {
        this.session.setDefaultTargetDocument((Object)new String("defaultOutput"));
        Assertions.assertNotNull((Object)this.session.getDefaultTargetDocument());
        Assertions.assertTrue((boolean)(this.session.getDefaultTargetDocument() instanceof String));
        Assertions.assertEquals((Object)"defaultOutput", (Object)this.session.getDefaultTargetDocument());
        Assertions.assertNotNull((Object)this.session.getTargetDocument(null));
        Assertions.assertNotNull((Object)this.session.getTargetDocument(""));
        Assertions.assertNotNull((Object)this.session.getTargetDocument("second"));
        this.session.setTargetDocument("second", (Object)new String("secondOutput"));
        Assertions.assertNotNull((Object)this.session.getDefaultTargetDocument());
        Assertions.assertTrue((boolean)(this.session.getDefaultTargetDocument() instanceof String));
        Assertions.assertEquals((Object)"defaultOutput", (Object)this.session.getDefaultTargetDocument());
        Assertions.assertTrue((boolean)this.session.hasTargetDocument("second"));
        Assertions.assertFalse((boolean)this.session.hasTargetDocument("third"));
        Assertions.assertNotNull((Object)this.session.getTargetDocument("second"));
        Assertions.assertTrue((boolean)(this.session.getTargetDocument("second") instanceof String));
        Assertions.assertEquals((Object)"secondOutput", (Object)this.session.getTargetDocument("second"));
        Assertions.assertNull((Object)this.session.getTargetDocument("docId"));
        Assertions.assertNotNull((Object)this.session.getTargetDocumentMap());
    }

    @Test
    public void testGetProperties() {
        Assertions.assertNotNull((Object)this.session);
        Assertions.assertNotNull((Object)this.session.getProperties());
        Assertions.assertTrue((this.session.getProperties().size() == 0 ? 1 : 0) != 0);
        this.session.getProperties().put("foo", "bar");
        Assertions.assertTrue((this.session.getProperties().size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"bar", this.session.getProperties().get("foo"));
    }

    @Test
    public void testAuditErrors() {
        Assertions.assertTrue((this.session.errorCount() == 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.session.hasErrors());
        Assertions.assertTrue((this.session.warnCount() == 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.session.hasWarns());
        Audit error = new Audit();
        error.setStatus(AuditStatus.ERROR);
        this.session.getAudits().getAudit().add(error);
        Assertions.assertTrue((this.session.errorCount() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.session.hasErrors());
        Assertions.assertTrue((this.session.warnCount() == 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.session.hasWarns());
    }

    @Test
    public void testAuditWarns() {
        Assertions.assertTrue((this.session.errorCount() == 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.session.hasErrors());
        Assertions.assertTrue((this.session.warnCount() == 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.session.hasWarns());
        Audit warn = new Audit();
        warn.setStatus(AuditStatus.WARN);
        this.session.getAudits().getAudit().add(warn);
        Assertions.assertTrue((this.session.errorCount() == 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.session.hasErrors());
        Assertions.assertTrue((this.session.warnCount() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.session.hasWarns());
    }

    @Test
    public void testSetTargetDocument() {
        this.session.setTargetDocument("target", (Object)"defaultOutput");
        this.session.setTargetDocument(null, (Object)"defaultOutput");
        this.session.setTargetDocument("", (Object)"defaultOutput");
        this.session.hasTargetDocument(null);
        this.session.hasTargetDocument("");
    }

    @Test
    public void testSetSourceDocument() {
        this.session.setSourceDocument("source", (Object)"defaultInput");
        this.session.setSourceDocument(null, (Object)"defaultInput");
        this.session.setSourceDocument("", (Object)"defaultInput");
    }

    @Test
    public void testGetFieldReader() {
        AtlasFieldReader reader = new AtlasFieldReader(){

            public Field read(AtlasInternalSession session) throws AtlasException {
                LOG.debug("read method");
                return session.head().getSourceField();
            }
        };
        this.session.setFieldReader("ATLAS_DEFAULT_SOURCE_DOC", reader);
        Assertions.assertNotNull((Object)this.session.getFieldReader(null));
        Assertions.assertNotNull((Object)this.session.getFieldReader(""));
        Assertions.assertNotNull((Object)this.session.getFieldReader("ATLAS_DEFAULT_SOURCE_DOC"));
        Assertions.assertNotNull((Object)this.session.getFieldReader("", AtlasFieldReader.class));
    }

    @Test
    public void testSetFieldReader() {
        AtlasFieldReader reader = new AtlasFieldReader(){

            public Field read(AtlasInternalSession session) throws AtlasException {
                LOG.debug("read method");
                return session.head().getSourceField();
            }
        };
        this.session.setFieldReader(null, reader);
        this.session.setFieldReader("", reader);
    }

    @Test
    public void testRemoveFieldReader() {
        this.session.removeFieldReader(null);
        this.session.removeFieldReader("");
        this.session.removeFieldReader("ATLAS_DEFAULT_SOURCE_DOC");
    }

    @Test
    public void testGetFieldWriter() {
        AtlasFieldWriter writer = new AtlasFieldWriter(){

            public void write(AtlasInternalSession session) throws AtlasException {
                LOG.debug("write method");
            }
        };
        this.session.setFieldWriter("ATLAS_DEFAULT_TARGET_DOC", writer);
        Assertions.assertNotNull((Object)this.session.getFieldWriter(null));
        Assertions.assertNotNull((Object)this.session.getFieldWriter(""));
        Assertions.assertNotNull((Object)this.session.getFieldWriter("ATLAS_DEFAULT_TARGET_DOC"));
        Assertions.assertNotNull((Object)this.session.getFieldWriter("", AtlasFieldWriter.class));
    }

    @Test
    public void testSetFieldWriter() {
        AtlasFieldWriter writer = new AtlasFieldWriter(){

            public void write(AtlasInternalSession session) throws AtlasException {
                LOG.debug("write method");
            }
        };
        this.session.setFieldWriter(null, writer);
        this.session.setFieldWriter("", writer);
    }

    @Test
    public void testRemoveFieldWriter() {
        this.session.removeFieldWriter(null);
        this.session.removeFieldWriter("");
        this.session.removeFieldWriter("ATLAS_DEFAULT_TARGET_DOC");
    }

    @Test
    public void testHead() {
        AtlasInternalSession.Head head = this.session.head();
        Assertions.assertNotNull((Object)head);
        Assertions.assertNull((Object)head.getLookupTable());
        Assertions.assertNull((Object)head.getMapping());
        Assertions.assertNull((Object)head.getSourceField());
        Assertions.assertNull((Object)head.getTargetField());
        head.setLookupTable(null);
        head.setMapping(null);
        head.setSourceField(null);
        head.setTargetField(null);
        Assertions.assertNotNull((Object)head.unset());
    }
}

