/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.StringConverter;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultAtlasConversionServiceTest {
    private AtlasConversionService service = null;

    @BeforeEach
    public void setUp() {
        this.service = DefaultAtlasConversionService.getInstance();
    }

    @AfterEach
    public void tearDown() {
        if (this.service != null) {
            this.service = null;
        }
    }

    @Test
    public void getservice() {
        Assertions.assertNotNull((Object)this.service);
        DefaultAtlasConversionService service2 = DefaultAtlasConversionService.getInstance();
        Assertions.assertNotNull((Object)service2);
        Assertions.assertSame((Object)this.service, (Object)service2);
    }

    @Test
    public void findMatchingConverterByFieldTypes() {
        Assertions.assertNotNull((Object)this.service);
        Optional atlasConverter = this.service.findMatchingConverter(FieldType.STRING, FieldType.BOOLEAN);
        Assertions.assertTrue((boolean)atlasConverter.isPresent());
        Assertions.assertNotNull((Object)atlasConverter);
        Assertions.assertEquals(StringConverter.class, ((AtlasConverter)atlasConverter.get()).getClass());
        StringConverter stringConverter = (StringConverter)atlasConverter.get();
        Assertions.assertNotNull((Object)stringConverter);
        Assertions.assertEquals((Object)"io.atlasmap.converters.StringConverter", (Object)((AtlasConverter)atlasConverter.get()).getClass().getCanonicalName());
        Boolean t = stringConverter.toBoolean("T", null, null);
        Assertions.assertNotNull((Object)t);
        Assertions.assertTrue((boolean)t);
        Boolean f = stringConverter.toBoolean("F", null, null);
        Assertions.assertNotNull((Object)f);
        Assertions.assertFalse((boolean)f);
        this.service.findMatchingConverter(null, FieldType.BOOLEAN);
        this.service.findMatchingConverter(FieldType.STRING, null);
        FieldType fieldType = null;
        this.service.findMatchingConverter(fieldType, fieldType);
    }

    @Test
    public void findMatchingConverterByFieldTypesCustomConverter() {
        Assertions.assertNotNull((Object)this.service);
        Optional atlasConverter = this.service.findMatchingConverter(FieldType.STRING, FieldType.STRING);
        Assertions.assertNotNull((Object)atlasConverter);
        Assertions.assertTrue((boolean)atlasConverter.isPresent());
        Assertions.assertTrue((boolean)AtlasConverter.class.isAssignableFrom(((AtlasConverter)atlasConverter.get()).getClass()));
        Assertions.assertEquals((Object)"io.atlasmap.converters.StringConverter", (Object)((AtlasConverter)atlasConverter.get()).getClass().getCanonicalName());
    }

    @Test
    public void findMatchingConverterByFieldTypesNoMatching() {
        Assertions.assertNotNull((Object)this.service);
        Optional atlasConverter = this.service.findMatchingConverter(FieldType.STRING, FieldType.COMPLEX);
        Assertions.assertFalse((boolean)atlasConverter.isPresent());
    }

    @Test
    public void findMatchingConverterBySourceClass() {
        Assertions.assertNotNull((Object)this.service);
        Optional atlasConverter = this.service.findMatchingConverter("java.util.Date", "java.time.ZonedDateTime");
        Assertions.assertNotNull((Object)atlasConverter);
        Assertions.assertTrue((boolean)atlasConverter.isPresent());
        Assertions.assertTrue((boolean)AtlasConverter.class.isAssignableFrom(((AtlasConverter)atlasConverter.get()).getClass()));
        Assertions.assertEquals((Object)"io.atlasmap.converters.DateConverter", (Object)((AtlasConverter)atlasConverter.get()).getClass().getCanonicalName());
    }

    @Test
    public void findMatchingConverterBySourceClassNoMatching() {
        Assertions.assertNotNull((Object)this.service);
        Optional atlasConverter = this.service.findMatchingConverter("java.util.Date", "java.time.CustomClass");
        Assertions.assertFalse((boolean)atlasConverter.isPresent());
    }

    @Test
    public void testIsPrimitiveClass() {
        Assertions.assertTrue((boolean)this.service.isPrimitive(Boolean.TYPE));
        Assertions.assertTrue((boolean)this.service.isPrimitive(Byte.TYPE));
        Assertions.assertTrue((boolean)this.service.isPrimitive(Character.TYPE));
        Assertions.assertTrue((boolean)this.service.isPrimitive(Double.TYPE));
        Assertions.assertTrue((boolean)this.service.isPrimitive(Float.TYPE));
        Assertions.assertTrue((boolean)this.service.isPrimitive(Integer.TYPE));
        Assertions.assertTrue((boolean)this.service.isPrimitive(Long.TYPE));
        Assertions.assertTrue((boolean)this.service.isPrimitive(Short.TYPE));
        Assertions.assertFalse((boolean)this.service.isPrimitive(Boolean.class));
        Assertions.assertFalse((boolean)this.service.isPrimitive(Byte.class));
        Assertions.assertFalse((boolean)this.service.isPrimitive(Character.class));
        Assertions.assertFalse((boolean)this.service.isPrimitive(Double.class));
        Assertions.assertFalse((boolean)this.service.isPrimitive(Float.class));
        Assertions.assertFalse((boolean)this.service.isPrimitive(Integer.class));
        Assertions.assertFalse((boolean)this.service.isPrimitive(Long.class));
        Assertions.assertFalse((boolean)this.service.isPrimitive(Short.class));
        Assertions.assertFalse((boolean)this.service.isPrimitive(String.class));
        Assertions.assertFalse((boolean)this.service.isPrimitive(AtlasMapping.class));
        Assertions.assertFalse((boolean)this.service.isPrimitive(List.class));
        Assertions.assertFalse((boolean)this.service.isPrimitive((Class)null));
    }

    @Test
    public void testIsPrimitiveFieldType() {
        Assertions.assertTrue((boolean)this.service.isPrimitive(FieldType.BOOLEAN));
        Assertions.assertTrue((boolean)this.service.isPrimitive(FieldType.BYTE));
        Assertions.assertTrue((boolean)this.service.isPrimitive(FieldType.CHAR));
        Assertions.assertTrue((boolean)this.service.isPrimitive(FieldType.DECIMAL));
        Assertions.assertTrue((boolean)this.service.isPrimitive(FieldType.DOUBLE));
        Assertions.assertTrue((boolean)this.service.isPrimitive(FieldType.FLOAT));
        Assertions.assertTrue((boolean)this.service.isPrimitive(FieldType.INTEGER));
        Assertions.assertTrue((boolean)this.service.isPrimitive(FieldType.LONG));
        Assertions.assertTrue((boolean)this.service.isPrimitive(FieldType.SHORT));
        Assertions.assertTrue((boolean)this.service.isPrimitive(FieldType.STRING));
        Assertions.assertFalse((boolean)this.service.isPrimitive(FieldType.ANY));
        Assertions.assertFalse((boolean)this.service.isPrimitive(FieldType.BYTE_ARRAY));
        Assertions.assertFalse((boolean)this.service.isPrimitive(FieldType.COMPLEX));
        Assertions.assertFalse((boolean)this.service.isPrimitive(FieldType.DATE));
        Assertions.assertFalse((boolean)this.service.isPrimitive(FieldType.DATE_TIME));
        Assertions.assertFalse((boolean)this.service.isPrimitive(FieldType.DATE_TIME_TZ));
        Assertions.assertFalse((boolean)this.service.isPrimitive(FieldType.DATE_TZ));
        Assertions.assertFalse((boolean)this.service.isPrimitive(FieldType.TIME));
        Assertions.assertFalse((boolean)this.service.isPrimitive(FieldType.TIME_TZ));
        Assertions.assertFalse((boolean)this.service.isPrimitive((FieldType)null));
    }

    @Test
    public void testIsBoxedPrimitive() {
        Assertions.assertTrue((boolean)this.service.isBoxedPrimitive(Boolean.class));
        Assertions.assertTrue((boolean)this.service.isBoxedPrimitive(Byte.class));
        Assertions.assertTrue((boolean)this.service.isBoxedPrimitive(Character.class));
        Assertions.assertTrue((boolean)this.service.isBoxedPrimitive(Double.class));
        Assertions.assertTrue((boolean)this.service.isBoxedPrimitive(Float.class));
        Assertions.assertTrue((boolean)this.service.isBoxedPrimitive(Integer.class));
        Assertions.assertTrue((boolean)this.service.isBoxedPrimitive(Long.class));
        Assertions.assertTrue((boolean)this.service.isBoxedPrimitive(Short.class));
        Assertions.assertTrue((boolean)this.service.isBoxedPrimitive(String.class));
        Assertions.assertFalse((boolean)this.service.isBoxedPrimitive(Boolean.TYPE));
        Assertions.assertFalse((boolean)this.service.isBoxedPrimitive(Byte.TYPE));
        Assertions.assertFalse((boolean)this.service.isBoxedPrimitive(Character.TYPE));
        Assertions.assertFalse((boolean)this.service.isBoxedPrimitive(Double.TYPE));
        Assertions.assertFalse((boolean)this.service.isBoxedPrimitive(Float.TYPE));
        Assertions.assertFalse((boolean)this.service.isBoxedPrimitive(Integer.TYPE));
        Assertions.assertFalse((boolean)this.service.isBoxedPrimitive(Long.TYPE));
        Assertions.assertFalse((boolean)this.service.isBoxedPrimitive(Short.TYPE));
        Assertions.assertFalse((boolean)this.service.isBoxedPrimitive(AtlasMapping.class));
        Assertions.assertFalse((boolean)this.service.isBoxedPrimitive(List.class));
        Assertions.assertFalse((boolean)this.service.isBoxedPrimitive((Class)null));
    }

    @Test
    public void testBoxOrUnboxPrimitive() {
        Assertions.assertEquals(Boolean.class, (Object)this.service.boxOrUnboxPrimitive(Boolean.TYPE));
        Assertions.assertEquals(Boolean.TYPE, (Object)this.service.boxOrUnboxPrimitive(Boolean.class));
        Assertions.assertEquals(Byte.class, (Object)this.service.boxOrUnboxPrimitive(Byte.TYPE));
        Assertions.assertEquals(Byte.TYPE, (Object)this.service.boxOrUnboxPrimitive(Byte.class));
        Assertions.assertEquals(Character.class, (Object)this.service.boxOrUnboxPrimitive(Character.TYPE));
        Assertions.assertEquals(Character.TYPE, (Object)this.service.boxOrUnboxPrimitive(Character.class));
        Assertions.assertEquals(Double.class, (Object)this.service.boxOrUnboxPrimitive(Double.TYPE));
        Assertions.assertEquals(Double.TYPE, (Object)this.service.boxOrUnboxPrimitive(Double.class));
        Assertions.assertEquals(Float.class, (Object)this.service.boxOrUnboxPrimitive(Float.TYPE));
        Assertions.assertEquals(Float.TYPE, (Object)this.service.boxOrUnboxPrimitive(Float.class));
        Assertions.assertEquals(Integer.class, (Object)this.service.boxOrUnboxPrimitive(Integer.TYPE));
        Assertions.assertEquals(Integer.TYPE, (Object)this.service.boxOrUnboxPrimitive(Integer.class));
        Assertions.assertEquals(Long.class, (Object)this.service.boxOrUnboxPrimitive(Long.TYPE));
        Assertions.assertEquals(Long.TYPE, (Object)this.service.boxOrUnboxPrimitive(Long.class));
        Assertions.assertEquals(Short.class, (Object)this.service.boxOrUnboxPrimitive(Short.TYPE));
        Assertions.assertEquals(Short.TYPE, (Object)this.service.boxOrUnboxPrimitive(Short.class));
        Assertions.assertEquals(String.class, (Object)this.service.boxOrUnboxPrimitive(String.class));
        Assertions.assertNotEquals(Boolean.class, (Object)this.service.boxOrUnboxPrimitive(Boolean.class));
        Assertions.assertNotEquals(Boolean.TYPE, (Object)this.service.boxOrUnboxPrimitive(Boolean.TYPE));
        Assertions.assertNotEquals(Byte.class, (Object)this.service.boxOrUnboxPrimitive(Byte.class));
        Assertions.assertNotEquals(Byte.TYPE, (Object)this.service.boxOrUnboxPrimitive(Byte.TYPE));
        Assertions.assertNotEquals(Character.class, (Object)this.service.boxOrUnboxPrimitive(Character.class));
        Assertions.assertNotEquals(Character.TYPE, (Object)this.service.boxOrUnboxPrimitive(Character.TYPE));
        Assertions.assertNotEquals(Double.class, (Object)this.service.boxOrUnboxPrimitive(Double.class));
        Assertions.assertNotEquals(Double.TYPE, (Object)this.service.boxOrUnboxPrimitive(Double.TYPE));
        Assertions.assertNotEquals(Float.class, (Object)this.service.boxOrUnboxPrimitive(Float.class));
        Assertions.assertNotEquals(Float.TYPE, (Object)this.service.boxOrUnboxPrimitive(Float.TYPE));
        Assertions.assertNotEquals(Integer.class, (Object)this.service.boxOrUnboxPrimitive(Integer.class));
        Assertions.assertNotEquals(Integer.TYPE, (Object)this.service.boxOrUnboxPrimitive(Integer.TYPE));
        Assertions.assertNotEquals(Long.class, (Object)this.service.boxOrUnboxPrimitive(Long.class));
        Assertions.assertNotEquals(Long.TYPE, (Object)this.service.boxOrUnboxPrimitive(Long.TYPE));
        Assertions.assertNotEquals(Short.class, (Object)this.service.boxOrUnboxPrimitive(Short.class));
        Assertions.assertNotEquals(Short.TYPE, (Object)this.service.boxOrUnboxPrimitive(Short.TYPE));
        Assertions.assertNotEquals(String.class, (Object)this.service.boxOrUnboxPrimitive(List.class));
        Assertions.assertNull((Object)this.service.boxOrUnboxPrimitive((Class)null));
    }

    @Test
    public void testCopyPrimitive() {
        Object sourceValue = null;
        Object targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNull((Object)targetValue);
        sourceValue = true;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Boolean.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)targetValue);
        sourceValue = false;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Boolean.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)targetValue);
        sourceValue = (byte)1;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Byte.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)1, (Object)targetValue);
        sourceValue = (byte)0;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Byte.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)0, (Object)targetValue);
        sourceValue = Character.valueOf('a');
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Character.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Character.valueOf('a'), (Object)targetValue);
        sourceValue = Character.valueOf('z');
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Character.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Character.valueOf('z'), (Object)targetValue);
        sourceValue = Double.MIN_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Double.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Double.MIN_VALUE, (Object)targetValue);
        sourceValue = Double.MAX_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Double.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Double.MAX_VALUE, (Object)targetValue);
        sourceValue = Float.valueOf(Float.MIN_VALUE);
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Float.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Float.valueOf(Float.MIN_VALUE), (Object)targetValue);
        sourceValue = Float.valueOf(Float.MAX_VALUE);
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Float.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)targetValue);
        sourceValue = Integer.MIN_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Integer.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Integer.MIN_VALUE, (Object)targetValue);
        sourceValue = Integer.MAX_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Integer.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)targetValue);
        sourceValue = Long.MIN_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Long.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Long.MIN_VALUE, (Object)targetValue);
        sourceValue = Long.MAX_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Long.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Long.MAX_VALUE, (Object)targetValue);
        sourceValue = (short)Short.MIN_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Short.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Short.MIN_VALUE, (Object)targetValue);
        sourceValue = (short)Short.MAX_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertTrue((boolean)Short.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assertions.assertEquals((Object)Short.MAX_VALUE, (Object)targetValue);
        sourceValue = new ArrayList();
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertEquals((Object)sourceValue, (Object)targetValue);
        sourceValue = "foo";
        targetValue = this.service.copyPrimitive(sourceValue);
        Assertions.assertNotNull((Object)targetValue);
        Assertions.assertEquals((Object)"foo", (Object)targetValue);
    }

    @Test
    public void testListPrimitiveClassNames() {
        Assertions.assertNotNull((Object)DefaultAtlasConversionService.listPrimitiveClassNames());
    }

    @Test
    public void testIsPrimitive() {
        Assertions.assertTrue((boolean)this.service.isPrimitive("short"));
        String s = null;
        Assertions.assertFalse((boolean)this.service.isPrimitive(s));
        Assertions.assertFalse((boolean)this.service.isPrimitive("String"));
    }

    @Test
    public void testFieldTypeFromClass() {
        String className = null;
        Assertions.assertEquals((Object)FieldType.NONE, (Object)this.service.fieldTypeFromClass(className));
        className = "";
        Assertions.assertEquals((Object)FieldType.NONE, (Object)this.service.fieldTypeFromClass(className));
        Class klass = null;
        Assertions.assertNull((Object)this.service.fieldTypeFromClass(klass));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Object.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Boolean.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Byte.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Character.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Double.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Float.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Integer.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Long.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Short.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(String.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Year.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Month.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(YearMonth.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(MonthDay.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(LocalDate.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(LocalTime.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(LocalDateTime.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(Date.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(java.util.Date.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass(ZonedDateTime.class));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass("boolean"));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass("byte"));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass("char"));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass("double"));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass("float"));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass("int"));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass("long"));
        Assertions.assertNotNull((Object)this.service.fieldTypeFromClass("short"));
    }

    @Test
    public void testClassFromFieldType() {
        Assertions.assertNull((Object)this.service.classFromFieldType(null));
        Assertions.assertEquals(Object.class, (Object)this.service.classFromFieldType(FieldType.ANY));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.BOOLEAN));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.BYTE));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.CHAR));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.DOUBLE));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.FLOAT));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.INTEGER));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.LONG));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.SHORT));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.STRING));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.DATE));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.TIME));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.DATE_TIME));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.DATE_TZ));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.TIME_TZ));
        Assertions.assertNotNull((Object)this.service.classFromFieldType(FieldType.DATE_TIME_TZ));
        Assertions.assertNull((Object)this.service.classFromFieldType(FieldType.NONE));
    }

    @Test
    public void testConvertTypeFromBigDecimal() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)true, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.CHAR));
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.LONG));
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.SHORT));
        Assertions.assertEquals((Object)"1", (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.STRING));
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.TIME).getClass());
        Assertions.assertEquals((Object)-1.68, (Object)this.service.convertType((Object)BigDecimal.valueOf(-1.68), null, FieldType.DOUBLE, null));
        Assertions.assertEquals((Object)Float.valueOf(-1.68f), (Object)this.service.convertType((Object)BigDecimal.valueOf(-1.68f), null, FieldType.FLOAT, null));
        Assertions.assertEquals((Object)Float.valueOf(-1.68f).doubleValue(), (Object)this.service.convertType((Object)BigDecimal.valueOf(-1.68f), null, FieldType.DOUBLE, null));
        Assertions.assertEquals((Object)Float.valueOf(-1.68f), (Object)this.service.convertType((Object)BigDecimal.valueOf(-1.68), null, FieldType.FLOAT, null));
    }

    @Test
    public void testConvertTypeFromBigInteger() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)true, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.CHAR));
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.LONG));
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.SHORT));
        Assertions.assertEquals((Object)"1", (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.STRING));
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.TIME).getClass());
        Assertions.assertEquals((Object)-2.0, (Object)this.service.convertType((Object)BigInteger.valueOf(-2L), null, FieldType.DOUBLE, null));
        Assertions.assertEquals((Object)Float.valueOf(-2.0f), (Object)this.service.convertType((Object)BigInteger.valueOf(-2L), null, FieldType.FLOAT, null));
    }

    @Test
    public void testConvertTypeFromBoolean() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)true, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.CHAR));
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.LONG));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.SHORT));
        Assertions.assertEquals((Object)"true", (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.STRING));
    }

    @Test
    public void testConvertTypeFromByte() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)true, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.CHAR));
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.LONG));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.SHORT));
        Assertions.assertEquals((Object)"1", (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.STRING));
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromCharacter() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(97L), (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)false, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)97, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('a'), (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.CHAR));
        Assertions.assertEquals((Object)BigDecimal.valueOf(97L), (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.DECIMAL));
        Assertions.assertEquals((Object)97.0, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(97.0f), (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.FLOAT));
        Assertions.assertEquals((Object)97, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.INTEGER));
        Assertions.assertEquals((Object)97L, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.LONG));
        Assertions.assertEquals((Object)97, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.NUMBER));
        Assertions.assertEquals((Object)97, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.SHORT));
        Assertions.assertEquals((Object)"a", (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.STRING));
    }

    @Test
    public void testConvertTypeFromDate() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(new java.util.Date(1L).getTime()), (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.BYTE));
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.LONG));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.SHORT));
        Assertions.assertEquals(String.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.STRING).getClass());
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.TIME).getClass());
        Assertions.assertEquals(LocalDateTime.class, this.service.convertType((Object)new java.util.Date(1L), null, LocalDateTime.class, null).getClass());
    }

    @Test
    public void testConvertTypeFromDouble() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)true, (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.CHAR));
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals((Object)BigDecimal.valueOf(1.0), (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.LONG));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.SHORT));
        Assertions.assertEquals((Object)"1.0", (Object)this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.STRING));
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)1.0, FieldType.DOUBLE, FieldType.TIME).getClass());
        Assertions.assertEquals((Object)Float.valueOf(-1.68f), (Object)this.service.convertType((Object)-1.68, null, FieldType.FLOAT, null));
    }

    @Test
    public void testConvertTypeFromFloat() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)true, (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.CHAR));
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals((Object)BigDecimal.valueOf(1.0), (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.LONG));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.SHORT));
        Assertions.assertEquals((Object)"1.0", (Object)this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.STRING));
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)Float.valueOf(1.0f), FieldType.FLOAT, FieldType.TIME).getClass());
        Assertions.assertEquals((Object)Float.valueOf(-1.68f).doubleValue(), (Object)this.service.convertType((Object)Float.valueOf(-1.68f), null, FieldType.DOUBLE, null));
    }

    @Test
    public void testConvertTypeFromInteger() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)true, (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.CHAR));
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)1, FieldType.INTEGER, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)1, FieldType.INTEGER, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.INTEGER, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.INTEGER, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.INTEGER, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.LONG));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.SHORT));
        Assertions.assertEquals((Object)"1", (Object)this.service.convertType((Object)1, FieldType.INTEGER, FieldType.STRING));
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)1, FieldType.INTEGER, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromLocalDate() throws AtlasConversionException {
        Assertions.assertEquals(BigInteger.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.BIG_INTEGER).getClass());
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals(BigDecimal.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DECIMAL).getClass());
        Assertions.assertEquals(Double.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DOUBLE).getClass());
        Assertions.assertEquals(Float.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.FLOAT).getClass());
        Assertions.assertEquals(Long.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.LONG).getClass());
        Assertions.assertEquals(Long.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.NUMBER).getClass());
        Assertions.assertEquals(String.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.STRING).getClass());
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromLocalTime() throws AtlasConversionException {
        Assertions.assertEquals(BigInteger.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.BIG_INTEGER).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals(BigDecimal.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.DECIMAL).getClass());
        Assertions.assertEquals(Double.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.DOUBLE).getClass());
        Assertions.assertEquals(Float.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.FLOAT).getClass());
        Assertions.assertEquals(Long.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.LONG).getClass());
        Assertions.assertEquals(Long.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.NUMBER).getClass());
        Assertions.assertEquals(String.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.STRING).getClass());
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromLong() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)true, (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.CHAR));
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)1L, FieldType.LONG, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)1L, FieldType.LONG, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1L, FieldType.LONG, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1L, FieldType.LONG, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1L, FieldType.LONG, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.LONG));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.SHORT));
        Assertions.assertEquals((Object)"1", (Object)this.service.convertType((Object)1L, FieldType.LONG, FieldType.STRING));
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)1L, FieldType.LONG, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromNumber() throws AtlasConversionException {
        Integer number = 1;
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)true, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.CHAR));
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.LONG));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.SHORT));
        Assertions.assertEquals((Object)"1", (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.STRING));
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromShort() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)true, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.CHAR));
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.LONG));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.SHORT));
        Assertions.assertEquals((Object)"1", (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.STRING));
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromString() throws AtlasConversionException {
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.BIG_INTEGER));
        Assertions.assertEquals((Object)true, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.BOOLEAN));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.BYTE));
        Assertions.assertEquals((Object)Character.valueOf('1'), (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.CHAR));
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)"1970-01-01", FieldType.STRING, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)"1970-01-01T00:00:00.000Z", FieldType.STRING, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)"1970-01-01T00:00:00.000Z", FieldType.STRING, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)"1970-01-01T00:00:00.000Z", FieldType.STRING, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)"1970-01-01T00:00:00.000Z", FieldType.STRING, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.DECIMAL));
        Assertions.assertEquals((Object)1.0, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.DOUBLE));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.FLOAT));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.INTEGER));
        Assertions.assertEquals((Object)1L, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.LONG));
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.NUMBER));
        Assertions.assertEquals((Object)1, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.SHORT));
        Assertions.assertEquals((Object)"1", (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.STRING));
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)"00:00:00.000", FieldType.STRING, FieldType.TIME).getClass());
        Assertions.assertEquals((Object)-1.68, (Object)this.service.convertType((Object)"-1.68", null, FieldType.DOUBLE, null));
        Assertions.assertEquals((Object)Float.valueOf(-1.68f), (Object)this.service.convertType((Object)"-1.68", null, FieldType.FLOAT, null));
    }

    @Test
    public void testConvertTypeFromZonedDateTime() throws AtlasConversionException {
        Assertions.assertEquals(BigInteger.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.BIG_INTEGER).getClass());
        Assertions.assertEquals(LocalDate.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DATE).getClass());
        Assertions.assertEquals(java.util.Date.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DATE_TIME).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DATE_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.TIME_TZ).getClass());
        Assertions.assertEquals(ZonedDateTime.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DATE_TIME_TZ).getClass());
        Assertions.assertEquals(BigDecimal.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DECIMAL).getClass());
        Assertions.assertEquals(Double.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DOUBLE).getClass());
        Assertions.assertEquals(Float.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.FLOAT).getClass());
        Assertions.assertEquals(Long.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.LONG).getClass());
        Assertions.assertEquals(Long.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.NUMBER).getClass());
        Assertions.assertEquals(String.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.STRING).getClass());
        Assertions.assertEquals(LocalTime.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeToAny() throws AtlasConversionException {
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.ANY, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.BIG_INTEGER, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.BOOLEAN, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.BYTE, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.CHAR, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DATE, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DATE_TIME, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DATE_TZ, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.TIME_TZ, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DATE_TIME, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DECIMAL, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DOUBLE, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.FLOAT, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.INTEGER, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.LONG, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.NUMBER, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.SHORT, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.STRING, FieldType.ANY));
        Assertions.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.TIME, FieldType.ANY));
    }

    @Test
    public void testConvertTypeAtlasConversionException() throws AtlasConversionException {
        Assertions.assertThrows(AtlasConversionException.class, () -> Assertions.assertNotNull((Object)this.service.convertType(new Object(), null, null)));
    }
}

