/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.AtlasPath;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AtlasPathTest {
    @Test
    public void testOneClass() {
        AtlasPath foo = new AtlasPath("");
        foo.appendField("user");
        Assertions.assertEquals((Object)"/user", (Object)foo.toString());
    }

    @Test
    public void testFields() {
        AtlasPath foo = new AtlasPath("");
        foo.appendField("user").appendField("name");
        Assertions.assertEquals((Object)"/user/name", (Object)foo.toString());
        foo.appendField("bar");
        Assertions.assertEquals((Object)"/user/name/bar", (Object)foo.toString());
    }

    @Test
    public void testCleanPathSegment() {
        Assertions.assertEquals((Object)"", (Object)new AtlasPath.SegmentContext("").getName());
        Assertions.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo").getName());
        Assertions.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo[]").getName());
        Assertions.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo<>").getName());
        Assertions.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo{}").getName());
        Assertions.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo[0]").getName());
        Assertions.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo<1234>").getName());
        Assertions.assertEquals((Object)"foo", (Object)new AtlasPath.SegmentContext("foo{bar}").getName());
        Assertions.assertEquals((Object)"foo[0", (Object)new AtlasPath.SegmentContext("foo[0").getName());
        Assertions.assertEquals((Object)"foo1234>", (Object)new AtlasPath.SegmentContext("foo1234>").getName());
        Assertions.assertEquals((Object)"foo}", (Object)new AtlasPath.SegmentContext("foo}").getName());
        Assertions.assertEquals((Object)"bar", (Object)new AtlasPath.SegmentContext("foo:bar").getName());
        Assertions.assertEquals((Object)"@bar", (Object)new AtlasPath.SegmentContext("foo:@bar").getName());
        Assertions.assertEquals((Object)"@bar", (Object)new AtlasPath.SegmentContext("@bar").getName());
    }

    @Test
    public void testGetLastSegmentParent() {
        AtlasPath p = new AtlasPath("/orders/contact/firstName");
        Assertions.assertEquals((Object)"contact", (Object)p.getLastSegmentParent().getName());
        Assertions.assertTrue((boolean)new AtlasPath("orders").getLastSegmentParent().isRoot());
    }

    @Test
    public void testGetLastSegmentParentPath() {
        AtlasPath p = new AtlasPath("/orders[]/contact/firstName");
        Assertions.assertEquals((Object)"/orders[]/contact", (Object)p.getLastSegmentParentPath().toString());
        Assertions.assertEquals((Object)"/", (Object)new AtlasPath("orders").getLastSegmentParentPath().toString());
    }

    @Test
    public void testCollectionIndexHandling() {
        Assertions.assertNull((Object)new AtlasPath.SegmentContext("").getCollectionIndex());
        Assertions.assertNull((Object)new AtlasPath.SegmentContext("foo").getCollectionIndex());
        Assertions.assertNull((Object)new AtlasPath.SegmentContext("foo[]").getCollectionIndex());
        Assertions.assertNull((Object)new AtlasPath.SegmentContext("foo<>").getCollectionIndex());
        Assertions.assertNull((Object)new AtlasPath.SegmentContext("foo{}").getCollectionIndex());
        Assertions.assertEquals((Integer)0, (Integer)new AtlasPath.SegmentContext("foo[0]").getCollectionIndex());
        Assertions.assertEquals((Integer)1234, (Integer)new AtlasPath.SegmentContext("foo<1234>").getCollectionIndex());
        Assertions.assertNull((Object)new AtlasPath.SegmentContext("foo{bar}").getCollectionIndex());
        AtlasPath p = new AtlasPath("/orders[4]/contact/firstName");
        p.setCollectionIndex(1, Integer.valueOf(5));
        Assertions.assertEquals((Object)"/orders[5]/contact/firstName", (Object)p.toString());
        Assertions.assertEquals((Integer)5, (Integer)((AtlasPath.SegmentContext)p.getSegments(true).get(1)).getCollectionIndex());
        try {
            p.setCollectionIndex(1, Integer.valueOf(-3));
            Assertions.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        AtlasPath q = new AtlasPath("/orders<4>/contact/firstName");
        q.setCollectionIndex(1, Integer.valueOf(6));
        Assertions.assertEquals((Object)"/orders<6>/contact/firstName", (Object)q.toString());
        Assertions.assertEquals((Integer)6, (Integer)((AtlasPath.SegmentContext)q.getSegments(true).get(1)).getCollectionIndex());
        AtlasPath r = new AtlasPath("/orders<>/contact/firstName");
        Assertions.assertEquals((Object)"orders<>", (Object)((AtlasPath.SegmentContext)r.getSegments(true).get(1)).getExpression());
        r.setCollectionIndex(1, Integer.valueOf(6));
        Assertions.assertEquals((Object)"/orders<6>/contact/firstName", (Object)r.toString());
        Assertions.assertEquals((Integer)6, (Integer)((AtlasPath.SegmentContext)r.getSegments(false).get(0)).getCollectionIndex());
    }

    @Test
    public void testIsIndexedCollection() {
        AtlasPath p = null;
        p = new AtlasPath("order");
        Assertions.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("/order/contact/firstName");
        Assertions.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("order[]");
        Assertions.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders[4]/contact/firstName");
        Assertions.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders[0]/contact/firstName");
        Assertions.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders[]/contact/firstName");
        Assertions.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("orders<>");
        Assertions.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("orders<6>");
        Assertions.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/foo/orders<6>");
        Assertions.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/foo/orders<6>/bar");
        Assertions.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders<3>/contact/firstName");
        Assertions.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders<0>/contact/firstName");
        Assertions.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders<>/contact/firstName");
        Assertions.assertFalse((boolean)p.isIndexedCollection());
    }

    @Test
    public void testGetLastSegment() {
        AtlasPath p = new AtlasPath("/order/contact/firstName");
        Assertions.assertEquals((Object)"firstName", (Object)p.getLastSegment().getName());
        Assertions.assertEquals((Object)"firstName", (Object)p.getLastSegment().getExpression());
        Assertions.assertTrue((boolean)new AtlasPath("").getLastSegment().isRoot());
        Assertions.assertNotNull((Object)p.getOriginalPath());
    }

    @Test
    public void testHasCollection() {
        AtlasPath p = new AtlasPath("/order/contact/firstName");
        Assertions.assertFalse((boolean)p.hasCollection());
    }

    @Test
    public void testIsCollectionRoot() {
        AtlasPath p = new AtlasPath("/order/contact/firstName");
        Assertions.assertFalse((boolean)p.isCollectionRoot());
        p = new AtlasPath("/order/contact/phone<>");
        Assertions.assertFalse((boolean)p.isCollectionRoot());
        p = new AtlasPath("/order<>/contact/phone");
        Assertions.assertFalse((boolean)p.isCollectionRoot());
        p = new AtlasPath("/<>/order/contact/phone");
        Assertions.assertFalse((boolean)p.isCollectionRoot());
    }

    @Test
    public void testIsAttributeSegment() {
        Assertions.assertFalse((boolean)((AtlasPath.SegmentContext)new AtlasPath((String)null).getSegments(true).get(0)).isAttribute());
        Assertions.assertFalse((boolean)((AtlasPath.SegmentContext)new AtlasPath("order").getSegments(false).get(0)).isAttribute());
        Assertions.assertTrue((boolean)((AtlasPath.SegmentContext)new AtlasPath("@order").getSegments(false).get(0)).isAttribute());
    }

    @Test
    public void testGetCollectionIndex() {
        AtlasPath p = new AtlasPath("orders/order[1]");
        Assertions.assertEquals((Integer)1, (Integer)((AtlasPath.SegmentContext)p.getSegments(false).get(1)).getCollectionIndex());
        p = new AtlasPath("order");
        Assertions.assertEquals(null, (Integer)((AtlasPath.SegmentContext)p.getSegments(false).get(0)).getCollectionIndex());
        p = new AtlasPath("orders/order<2>");
        Assertions.assertEquals((Integer)2, (Integer)((AtlasPath.SegmentContext)p.getSegments(false).get(1)).getCollectionIndex());
    }

    @Test
    public void testGetSegments() {
        AtlasPath path = new AtlasPath("/orders");
        Assertions.assertNotNull((Object)path.getSegments(true));
        List segmentContexts = path.getSegments(true);
        Assertions.assertNotNull((Object)segmentContexts);
        Assertions.assertEquals((int)2, (int)segmentContexts.size());
        AtlasPath.SegmentContext sc = (AtlasPath.SegmentContext)segmentContexts.get(1);
        Assertions.assertEquals((Object)"orders", (Object)sc.getName());
        Assertions.assertNull((Object)sc.getCollectionIndex());
        Assertions.assertEquals((Object)"orders", (Object)sc.getExpression());
        Assertions.assertNotNull((Object)sc.toString());
    }

    @Test
    public void testGetParentSegmentOf() throws Exception {
        AtlasPath path = new AtlasPath("/orders/order<4>/product<6>/name");
        List segments = path.getSegments(true);
        Assertions.assertEquals(null, (Object)path.getParentSegmentOf((AtlasPath.SegmentContext)segments.get(0)));
        Assertions.assertEquals(segments.get(0), (Object)path.getParentSegmentOf((AtlasPath.SegmentContext)segments.get(1)));
        Assertions.assertEquals(segments.get(1), (Object)path.getParentSegmentOf((AtlasPath.SegmentContext)segments.get(2)));
        Assertions.assertEquals(segments.get(2), (Object)path.getParentSegmentOf((AtlasPath.SegmentContext)segments.get(3)));
        Assertions.assertEquals(segments.get(3), (Object)path.getParentSegmentOf((AtlasPath.SegmentContext)segments.get(4)));
    }

    @Test
    public void testSanitize() throws Exception {
        AtlasPath path = new AtlasPath("//orders//order//product//name//");
        List segments = path.getSegments(true);
        Assertions.assertEquals((int)5, (int)segments.size());
        Assertions.assertEquals((Object)"", (Object)((AtlasPath.SegmentContext)segments.get(0)).getName());
        Assertions.assertEquals((Object)"orders", (Object)((AtlasPath.SegmentContext)segments.get(1)).getName());
        Assertions.assertEquals((Object)"order", (Object)((AtlasPath.SegmentContext)segments.get(2)).getName());
        Assertions.assertEquals((Object)"product", (Object)((AtlasPath.SegmentContext)segments.get(3)).getName());
        Assertions.assertEquals((Object)"name", (Object)((AtlasPath.SegmentContext)segments.get(4)).getName());
    }
}

