/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.IntegerConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IntegerConverterTest {
    private IntegerConverter converter = new IntegerConverter();

    @Test
    public void convertToBoolean() {
        int xTrue = 1;
        int xFalse = 0;
        Boolean out = this.converter.toBoolean(Integer.valueOf(xTrue));
        Assertions.assertNotNull((Object)out);
        Assertions.assertTrue((boolean)out);
        out = this.converter.toBoolean(Integer.valueOf(xFalse));
        Assertions.assertNotNull((Object)out);
        Assertions.assertFalse((boolean)out);
    }

    @Test
    public void convertToBooleanNull() {
        Boolean out = this.converter.toBoolean(null);
        Assertions.assertNull((Object)out);
    }

    @Test
    public void convertToBooleanHigh() {
        Boolean out = this.converter.toBoolean(Integer.valueOf(10));
        Assertions.assertTrue((boolean)out);
    }

    @Test
    public void convertToByte() throws Exception {
        Byte value = 100;
        Assertions.assertEquals((Byte)value, (Byte)this.converter.toByte(Integer.valueOf(100)));
    }

    @Test
    public void convertToByteOutOfRange() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> this.converter.toByte(Integer.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    public void convertToByteNull() throws Exception {
        Byte byt = this.converter.toByte(null);
        Assertions.assertNull((Object)byt);
    }

    @Test
    public void convertToCharacterNull() throws Exception {
        Character character = this.converter.toCharacter(null);
        Assertions.assertNull((Object)character);
    }

    @Test
    public void convertToCharacter() throws Exception {
        Integer integer = 4;
        Character character = this.converter.toCharacter(integer);
        Assertions.assertNotNull((Object)character);
        char revert = character.charValue();
        Assertions.assertEquals((Integer)integer, (Integer)Integer.valueOf(revert));
    }

    @Test
    public void convertToCharacterGreaterThanMAX() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Integer integer = 1500000;
            this.converter.toCharacter(integer);
        });
    }

    @Test
    public void convertToCharacterLessThanMIN() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Integer integer = -1500000;
            this.converter.toCharacter(integer);
        });
    }

    @Test
    public void convertToDouble() {
        Integer integer = 0;
        Double d = this.converter.toDouble(integer);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)d, (double)0.0, (double)0.0);
        integer = 1;
        d = this.converter.toDouble(integer);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)1.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Assertions.assertNull((Object)this.converter.toDouble(null));
    }

    @Test
    public void convertToFloat() {
        Integer integer = 0;
        Float f = this.converter.toFloat(integer);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)f.floatValue(), (double)0.0, (double)0.0);
        integer = 1;
        f = this.converter.toFloat(integer);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)1.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() {
        Assertions.assertNull((Object)this.converter.toFloat(null));
    }

    @Test
    public void convertToShort() throws Exception {
        int i = Short.MAX_VALUE;
        int negI = Short.MIN_VALUE;
        Short out = this.converter.toShort(Integer.valueOf(i));
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)i, (int)out.intValue());
        out = this.converter.toShort(Integer.valueOf(negI));
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)negI, (int)out.intValue());
    }

    @Test
    public void convertToShortNull() throws Exception {
        Short out = this.converter.toShort(null);
        Assertions.assertNull((Object)out);
    }

    @Test
    public void convertToShortConvertExceptionGreaterThanMax() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> this.converter.toShort(Integer.valueOf(Integer.MAX_VALUE)));
    }

    @Test
    public void convertToShortConvertExceptionLessThanMin() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> this.converter.toShort(Integer.valueOf(Integer.MIN_VALUE)));
    }

    @Test
    public void convertToLong() {
        int i = Integer.MAX_VALUE;
        int negI = Integer.MIN_VALUE;
        Long out = this.converter.toLong(Integer.valueOf(i));
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)i, (int)out.intValue());
        out = this.converter.toLong(Integer.valueOf(negI));
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((int)negI, (int)out.intValue());
    }

    @Test
    public void convertToLongNull() {
        Long out = this.converter.toLong(null);
        Assertions.assertNull((Object)out);
    }

    @Test
    public void convertToString() {
        int i = Integer.MAX_VALUE;
        int negI = Integer.MIN_VALUE;
        String out = this.converter.toString(Integer.valueOf(i));
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)Integer.toString(i), (Object)out);
        out = this.converter.toString(Integer.valueOf(negI));
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)Integer.toString(negI), (Object)out);
    }

    @Test
    public void convertToStringNull() {
        String out = this.converter.toString(null);
        Assertions.assertNull((Object)out);
    }

    @Test
    public void convertToInteger() {
        Integer foo = Integer.MAX_VALUE;
        Integer out = this.converter.toInteger(foo);
        Integer n = foo;
        Integer n2 = foo = Integer.valueOf(foo + 1);
        Assertions.assertNotNull((Object)out);
        Assertions.assertNotSame((Object)out, (Object)foo);
        Assertions.assertNotEquals((Integer)out, (Integer)foo);
    }

    @Test
    public void convertToIntegerNull() {
        Integer out = this.converter.toInteger(null);
        Assertions.assertNull((Object)out);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<IntegerConverter> aClass = IntegerConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assertions.assertNotNull((Object)annotations);
            Assertions.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assertions.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assertions.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assertions.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.INTEGER) == 0 ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assertions.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assertions.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }

    @Test
    public void testCharacterDigit() {
        int i = 4;
        int intTen = 10;
        char ch = Character.forDigit(i, intTen);
        Assertions.assertTrue((ch == '4' ? 1 : 0) != 0);
        int i2 = Character.digit(ch, intTen);
        Assertions.assertTrue((i2 == 4 ? 1 : 0) != 0);
    }
}

