/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory.bys.builder;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;

public class ByChained
extends org.openqa.selenium.support.pagefactory.ByChained {
    private final By[] bys;

    private static Function<SearchContext, WebElement> getSearchingFunction(By by) {
        return input -> {
            try {
                if (input == null) {
                    return null;
                }
                return input.findElement(by);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        };
    }

    public ByChained(By[] bys) {
        super(Objects.requireNonNull(bys));
        if (bys.length == 0) {
            throw new IllegalArgumentException("By array should not be empty");
        }
        this.bys = bys;
    }

    public WebElement findElement(SearchContext context) {
        Function searchingFunction = null;
        for (By by : this.bys) {
            searchingFunction = Optional.ofNullable(searchingFunction).map(sf -> sf.andThen(ByChained.getSearchingFunction(by))).orElseGet(() -> ByChained.getSearchingFunction(by));
        }
        Objects.requireNonNull(searchingFunction);
        try {
            return (WebElement)new FluentWait((Object)context).until(searchingFunction);
        }
        catch (TimeoutException e) {
            throw new NoSuchElementException("Cannot locate an element using " + this);
        }
    }
}

