/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.screenrecording.BaseStartScreenRecordingOptions;
import io.appium.java_client.screenrecording.ScreenRecordingUploadOptions;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IOSStartScreenRecordingOptions
extends BaseStartScreenRecordingOptions<IOSStartScreenRecordingOptions> {
    private String videoType;
    private String videoQuality;
    private String videoScale;
    private String videoFilters;
    private Integer fps;

    public static IOSStartScreenRecordingOptions startScreenRecordingOptions() {
        return new IOSStartScreenRecordingOptions();
    }

    @Override
    public IOSStartScreenRecordingOptions withUploadOptions(ScreenRecordingUploadOptions uploadOptions) {
        return (IOSStartScreenRecordingOptions)super.withUploadOptions(uploadOptions);
    }

    public IOSStartScreenRecordingOptions withVideoType(String videoType) {
        this.videoType = Objects.requireNonNull(videoType);
        return this;
    }

    public IOSStartScreenRecordingOptions withVideoQuality(VideoQuality videoQuality) {
        this.videoQuality = Objects.requireNonNull(videoQuality).name().toLowerCase();
        return this;
    }

    public IOSStartScreenRecordingOptions withFps(int fps) {
        this.fps = fps;
        return this;
    }

    public IOSStartScreenRecordingOptions withVideoScale(String videoScale) {
        this.videoScale = Objects.requireNonNull(videoScale);
        return this;
    }

    @Override
    public IOSStartScreenRecordingOptions withTimeLimit(Duration timeLimit) {
        return (IOSStartScreenRecordingOptions)super.withTimeLimit(timeLimit);
    }

    public IOSStartScreenRecordingOptions withVideoFilters(String filters) {
        this.videoFilters = filters;
        return this;
    }

    @Override
    public Map<String, Object> build() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(super.build());
        Optional.ofNullable(this.videoType).map(x -> builder.put((Object)"videoType", x));
        Optional.ofNullable(this.videoQuality).map(x -> builder.put((Object)"videoQuality", x));
        Optional.ofNullable(this.videoScale).map(x -> builder.put((Object)"videoScale", x));
        Optional.ofNullable(this.videoFilters).map(x -> builder.put((Object)"videoFilters", x));
        Optional.ofNullable(this.fps).map(x -> builder.put((Object)"videoFps", x));
        return builder.build();
    }

    public static enum VideoQuality {
        LOW,
        MEDIUM,
        HIGH,
        PHOTO;

    }
}

