/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.Widget;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.WebElement;

class WidgetConstructorUtil {
    private WidgetConstructorUtil() {
    }

    static Constructor<? extends Widget> findConvenientConstructor(Class<? extends Widget> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            Class<?> param;
            Class<?>[] params = constructor.getParameterTypes();
            if (constructor.getParameterTypes().length != 1 || !WebElement.class.isAssignableFrom(param = params[0])) continue;
            constructor.setAccessible(true);
            return constructor;
        }
        List<Constructor<?>> declared = Arrays.asList(clazz.getDeclaredConstructors());
        throw new NoSuchMethodError(clazz.getName() + " has no convenient constructor which could pass a " + WebElement.class.getName() + " instance as a parameter. The actual list of constructors: " + declared.toString());
    }
}

