/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.ws.StringWebSocketClient;
import java.net.URI;
import java.net.URL;
import java.util.function.Consumer;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

public interface ListensToSyslogMessages
extends ExecutesMethod {
    public StringWebSocketClient getSyslogClient();

    default public void startSyslogBroadcast() {
        this.startSyslogBroadcast("localhost");
    }

    default public void startSyslogBroadcast(String host) {
        this.startSyslogBroadcast(host, 4723);
    }

    default public void startSyslogBroadcast(String host, int port) {
        RemoteWebDriver remoteWebDriver = (RemoteWebDriver)this;
        URL serverUrl = ((HttpCommandExecutor)remoteWebDriver.getCommandExecutor()).getAddressOfRemoteServer();
        String scheme = "https".equals(serverUrl.getProtocol()) ? "wss" : "ws";
        CommandExecutionHelper.executeScript(this, "mobile: startLogsBroadcast");
        SessionId sessionId = remoteWebDriver.getSessionId();
        String endpoint = String.format("%s://%s:%s/ws/session/%s/appium/device/syslog", scheme, host, port, sessionId);
        this.getSyslogClient().connect(URI.create(endpoint));
    }

    default public void addSyslogMessagesListener(Consumer<String> handler) {
        this.getSyslogClient().addMessageHandler(handler);
    }

    default public void addSyslogErrorsListener(Consumer<Throwable> handler) {
        this.getSyslogClient().addErrorHandler(handler);
    }

    default public void addSyslogConnectionListener(Runnable handler) {
        this.getSyslogClient().addConnectionHandler(handler);
    }

    default public void addSyslogDisconnectionListener(Runnable handler) {
        this.getSyslogClient().addDisconnectionHandler(handler);
    }

    default public void removeAllSyslogListeners() {
        this.getSyslogClient().removeAllHandlers();
    }

    default public void stopSyslogBroadcast() {
        CommandExecutionHelper.executeScript(this, "mobile: stopLogsBroadcast");
    }
}

