/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.war.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class HttpRequestThreadLocalFilter
implements Filter {
    private static final ThreadLocal<HttpServletRequest> currentRequest = new ThreadLocal();

    private static final void setCurrentRequest(HttpServletRequest request) {
        currentRequest.set(request);
    }

    private static final void clearCurrentRequest() {
        currentRequest.remove();
    }

    public static final HttpServletRequest getCurrentRequest() {
        return currentRequest.get();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpRequestThreadLocalFilter.setCurrentRequest((HttpServletRequest)request);
        try {
            chain.doFilter(request, response);
        }
        finally {
            HttpRequestThreadLocalFilter.clearCurrentRequest();
        }
    }

    public void destroy() {
    }
}

