/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.war;

import io.apiman.gateway.api.rest.impl.IPlatform;
import io.apiman.gateway.engine.beans.ApiEndpoint;
import io.apiman.gateway.platforms.war.WarGateway;
import io.apiman.gateway.platforms.war.filters.HttpRequestThreadLocalFilter;
import javax.servlet.http.HttpServletRequest;

public class WarPlatform
implements IPlatform {
    public static final String APIMAN_GATEWAY_ENDPOINT = "apiman-gateway.public-endpoint";

    public ApiEndpoint getApiEndpoint(String organizationId, String apiId, String version) {
        String endpoint = WarGateway.config.getConfigProperty(APIMAN_GATEWAY_ENDPOINT, null);
        StringBuilder builder = new StringBuilder();
        if (endpoint == null) {
            HttpServletRequest currentRequest = HttpRequestThreadLocalFilter.getCurrentRequest();
            if (currentRequest == null) {
                throw new RuntimeException("No current request available.  Missing HttpRequestThreadLocalFilter from the web.xml?");
            }
            builder.append(currentRequest.getScheme());
            builder.append("://");
            builder.append(currentRequest.getServerName());
            int serverPort = currentRequest.getServerPort();
            if (serverPort != 80 && serverPort != 443) {
                builder.append(":").append(serverPort);
            }
            builder.append("/apiman-gateway/");
        } else {
            builder.append(endpoint);
            if (!endpoint.endsWith("/")) {
                builder.append("/");
            }
        }
        builder.append(organizationId);
        builder.append("/");
        builder.append(apiId);
        builder.append("/");
        builder.append(version);
        ApiEndpoint rval = new ApiEndpoint();
        rval.setEndpoint(builder.toString());
        return rval;
    }
}

