/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.war;

import io.apiman.common.config.ConfigFactory;
import io.apiman.common.logging.DefaultDelegateFactory;
import io.apiman.common.logging.IDelegateFactory;
import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginClassLoader;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.util.ReflectionUtils;
import io.apiman.common.util.crypt.IDataEncrypter;
import io.apiman.gateway.engine.EngineConfigTuple;
import io.apiman.gateway.engine.IComponent;
import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngineConfig;
import io.apiman.gateway.engine.IGatewayInitializer;
import io.apiman.gateway.engine.IMetrics;
import io.apiman.gateway.engine.IPluginRegistry;
import io.apiman.gateway.engine.IPolicyErrorWriter;
import io.apiman.gateway.engine.IPolicyFailureWriter;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.impl.DefaultPolicyErrorWriter;
import io.apiman.gateway.engine.impl.DefaultPolicyFailureWriter;
import io.apiman.gateway.engine.policy.IPolicyFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.configuration.Configuration;

public class WarEngineConfig
implements IEngineConfig {
    public static final String APIMAN_GATEWAY_REGISTRY_CLASS = "apiman-gateway.registry";
    public static final String APIMAN_GATEWAY_PLUGIN_REGISTRY_CLASS = "apiman-gateway.plugin-registry";
    public static final String APIMAN_GATEWAY_CONNECTOR_FACTORY_CLASS = "apiman-gateway.connector-factory";
    public static final String APIMAN_GATEWAY_POLICY_FACTORY_CLASS = "apiman-gateway.policy-factory";
    public static final String APIMAN_GATEWAY_METRICS_CLASS = "apiman-gateway.metrics";
    public static final String APIMAN_GATEWAY_LOGGER_FACTORY_CLASS = "apiman-gateway.logger-factory";
    public static final String APIMAN_DATA_ENCRYPTER_TYPE = "apiman.encrypter.type";
    public static final String APIMAN_GATEWAY_COMPONENT_PREFIX = "apiman-gateway.components.";
    public static final String APIMAN_GATEWAY_WRITER_FORMATTER_CLASS = "apiman-gateway.writers.policy-failure";
    public static final String APIMAN_GATEWAY_ERROR_WRITER_CLASS = "apiman-gateway.writers.error";
    public static final String APIMAN_GATEWAY_INITIALIZERS = "apiman-gateway.initializers";
    public static final Configuration config = ConfigFactory.createConfig();

    public Configuration getConfig() {
        return config;
    }

    public String getConfigProperty(String propertyName, String defaultValue) {
        return this.getConfig().getString(propertyName, defaultValue);
    }

    public Class<? extends IRegistry> getRegistryClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass(APIMAN_GATEWAY_REGISTRY_CLASS, IRegistry.class, pluginRegistry);
    }

    public Map<String, String> getRegistryConfig() {
        return this.getConfigMap(APIMAN_GATEWAY_REGISTRY_CLASS);
    }

    public Class<IPluginRegistry> getPluginRegistryClass() {
        return this.loadConfigClass(APIMAN_GATEWAY_PLUGIN_REGISTRY_CLASS, IPluginRegistry.class, null);
    }

    public Map<String, String> getPluginRegistryConfig() {
        Map<String, String> configMap = this.getConfigMap(APIMAN_GATEWAY_PLUGIN_REGISTRY_CLASS);
        String pluginsDirOverride = System.getProperty("apiman-gateway.plugin-registry.pluginsDir");
        if (pluginsDirOverride != null) {
            configMap.put("pluginsDir", pluginsDirOverride);
        }
        return configMap;
    }

    public Class<? extends IConnectorFactory> getConnectorFactoryClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass(APIMAN_GATEWAY_CONNECTOR_FACTORY_CLASS, IConnectorFactory.class, pluginRegistry);
    }

    public Map<String, String> getConnectorFactoryConfig() {
        return this.getConfigMap(APIMAN_GATEWAY_CONNECTOR_FACTORY_CLASS);
    }

    public Class<? extends IPolicyFactory> getPolicyFactoryClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass(APIMAN_GATEWAY_POLICY_FACTORY_CLASS, IPolicyFactory.class, pluginRegistry);
    }

    public Map<String, String> getPolicyFactoryConfig() {
        return this.getConfigMap(APIMAN_GATEWAY_POLICY_FACTORY_CLASS);
    }

    public Class<? extends IMetrics> getMetricsClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass(APIMAN_GATEWAY_METRICS_CLASS, IMetrics.class, pluginRegistry);
    }

    public Map<String, String> getMetricsConfig() {
        return this.getConfigMap(APIMAN_GATEWAY_METRICS_CLASS);
    }

    public <T extends IComponent> Class<T> getComponentClass(Class<T> componentType, IPluginRegistry pluginRegistry) {
        return this.loadConfigClass(APIMAN_GATEWAY_COMPONENT_PREFIX + componentType.getSimpleName(), componentType, pluginRegistry);
    }

    public <T extends IComponent> Map<String, String> getComponentConfig(Class<T> componentType) {
        return this.getConfigMap(APIMAN_GATEWAY_COMPONENT_PREFIX + componentType.getSimpleName());
    }

    public Class<? extends IDataEncrypter> getDataEncrypterClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass(APIMAN_DATA_ENCRYPTER_TYPE, IDataEncrypter.class, pluginRegistry);
    }

    public Map<String, String> getDataEncrypterConfig() {
        return this.getConfigMap("apiman.encrypter");
    }

    public Class<IPolicyFailureWriter> getPolicyFailureWriterClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass(APIMAN_GATEWAY_WRITER_FORMATTER_CLASS, IPolicyFailureWriter.class, pluginRegistry, DefaultPolicyFailureWriter.class);
    }

    public Map<String, String> getPolicyFailureWriterConfig() {
        return this.getConfigMap(APIMAN_GATEWAY_WRITER_FORMATTER_CLASS);
    }

    public Class<IPolicyErrorWriter> getPolicyErrorWriterClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass(APIMAN_GATEWAY_ERROR_WRITER_CLASS, IPolicyErrorWriter.class, pluginRegistry, DefaultPolicyErrorWriter.class);
    }

    public Map<String, String> getPolicyErrorWriterConfig() {
        return this.getConfigMap(APIMAN_GATEWAY_ERROR_WRITER_CLASS);
    }

    public Class<? extends IDelegateFactory> getLoggerFactoryClass(IPluginRegistry pluginRegistry) {
        return this.loadConfigClass(APIMAN_GATEWAY_LOGGER_FACTORY_CLASS, IDelegateFactory.class, pluginRegistry, DefaultDelegateFactory.class);
    }

    public Map<String, String> getLoggerFactoryConfig() {
        return this.getConfigMap(APIMAN_GATEWAY_LOGGER_FACTORY_CLASS);
    }

    public List<EngineConfigTuple<? extends IGatewayInitializer>> getGatewayInitializers(IPluginRegistry pluginRegistry) {
        ArrayList<EngineConfigTuple<? extends IGatewayInitializer>> rval = new ArrayList<EngineConfigTuple<? extends IGatewayInitializer>>();
        String initializerIds = this.getConfig().getString(APIMAN_GATEWAY_INITIALIZERS);
        if (initializerIds != null) {
            for (String initializerId : initializerIds.split(",")) {
                String initializerClassProp = "apiman-gateway.initializers." + initializerId;
                Class<IGatewayInitializer> initializerClass = this.loadConfigClass(initializerClassProp, IGatewayInitializer.class, pluginRegistry);
                Map<String, String> configMap = this.getConfigMap(initializerClassProp);
                rval.add((EngineConfigTuple<? extends IGatewayInitializer>)new EngineConfigTuple(initializerClass, configMap));
            }
        }
        return rval;
    }

    private <T> Class<? extends T> loadConfigClass(String property, Class<T> type, IPluginRegistry pluginRegistry) {
        Class<T> rval = this.loadConfigClass(property, type, pluginRegistry, null);
        if (rval == null) {
            throw new RuntimeException("No " + type.getSimpleName() + " class configured.");
        }
        return rval;
    }

    private <T> Class<? extends T> loadConfigClass(String property, Class<T> type, IPluginRegistry pluginRegistry, Class<? extends T> defaultClass) {
        String componentSpec = this.getConfig().getString(property);
        if (componentSpec == null) {
            return defaultClass;
        }
        try {
            if (componentSpec.startsWith("class:")) {
                Class c = ReflectionUtils.loadClass((String)componentSpec.substring("class:".length()));
                return c;
            }
            if (componentSpec.startsWith("plugin:")) {
                PluginCoordinates coordinates = PluginCoordinates.fromPolicySpec((String)componentSpec);
                if (coordinates == null) {
                    throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
                }
                int ssidx = componentSpec.indexOf(47);
                if (ssidx == -1) {
                    throw new IllegalArgumentException("Invalid plugin component spec: " + componentSpec);
                }
                String classname = componentSpec.substring(ssidx + 1);
                Future pluginF = pluginRegistry.loadPlugin(coordinates, null);
                IAsyncResult pluginR = (IAsyncResult)pluginF.get();
                if (pluginR.isError()) {
                    throw new RuntimeException(pluginR.getError());
                }
                Plugin plugin = (Plugin)pluginR.getResult();
                PluginClassLoader classLoader = plugin.getLoader();
                Class class1 = classLoader.loadClass(classname);
                return class1;
            }
            Class c = ReflectionUtils.loadClass((String)componentSpec);
            return c;
        }
        catch (ClassNotFoundException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getConfigMap(String prefix) {
        HashMap<String, String> rval = new HashMap<String, String>();
        Iterator keys = config.getKeys(prefix);
        while (keys.hasNext()) {
            String key = String.valueOf(keys.next());
            if (key.equals(prefix)) continue;
            String shortKey = key.substring(prefix.length() + 1);
            rval.put(shortKey, config.getString(key));
        }
        return rval;
    }
}

