/*
 * Copyright 2015 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.apiman.gateway.platforms.vertx3.services;

import io.apiman.gateway.engine.IEngine;
import io.apiman.gateway.platforms.vertx3.common.config.VertxEngineConfig;
import io.apiman.gateway.platforms.vertx3.services.impl.InitializeIngestorServiceImpl;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.serviceproxy.ProxyHelper;

/**
 * Create connection
 *
 * @author Marc Savy {@literal <msavy@redhat.com>}
 */
@ProxyGen
public interface InitializeIngestorService {

    void createIngestor(String uuid, Handler<AsyncResult<IngestorToPolicyService>> resultHandler);

    static InitializeIngestorService create(Vertx vertx,
            VertxEngineConfig engineConfig,
            IEngine engine,
            Logger log) {
        return new InitializeIngestorServiceImpl(vertx, engineConfig, engine, log);
    }

    static InitializeIngestorService createProxy(Vertx vertx, String address) {
        return ProxyHelper.createProxy(InitializeIngestorService.class, vertx, address);
    }
}
